/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SampleInstance;
import smile.data.SimpleDataset;
import smile.math.matrix.SparseMatrix;
import smile.util.SparseArray;

public class SparseDataset<T>
extends SimpleDataset<SparseArray, T> {
    private static final Logger logger = LoggerFactory.getLogger(SparseDataset.class);
    private int n;
    private final int ncol;
    private int[] colSize;

    public SparseDataset(Collection<SampleInstance<SparseArray, T>> data) {
        this(data, data.stream().flatMapToInt(instance -> ((SparseArray)instance.x()).indexStream()).max().orElse(0) + 1);
    }

    public SparseDataset(Collection<SampleInstance<SparseArray, T>> data, int ncol) {
        super(data);
        this.ncol = ncol;
        this.colSize = new int[ncol];
        for (SampleInstance instance : data) {
            SparseArray x = (SparseArray)instance.x();
            x.sort();
            int i = -1;
            for (SparseArray.Entry e : x) {
                if (e.index() < 0) {
                    throw new IllegalArgumentException(String.format("Negative index of nonzero element: %d", e.index()));
                }
                if (e.index() == i) {
                    logger.warn("Ignore duplicated indices: {} in {}", (Object)e.index(), (Object)x);
                    continue;
                }
                if (ncol <= e.index()) {
                    ncol = e.index() + 1;
                    int[] newColSize = new int[3 * ncol / 2];
                    System.arraycopy(this.colSize, 0, newColSize, 0, this.colSize.length);
                    this.colSize = newColSize;
                }
                int n = e.index();
                this.colSize[n] = this.colSize[n] + 1;
                ++this.n;
                i = e.index();
            }
        }
    }

    public int nz() {
        return this.n;
    }

    public int nz(int j) {
        return this.colSize[j];
    }

    public int nrow() {
        return this.size();
    }

    public int ncol() {
        return this.ncol;
    }

    public double get(int i, int j) {
        if (i < 0 || i >= this.size() || j < 0 || j >= this.ncol()) {
            throw new IllegalArgumentException("Invalid index: i = " + i + " j = " + j);
        }
        return ((SparseArray)this.get(i).x()).get(j);
    }

    public void unitize() {
        this.stream().forEach(instance -> {
            double sum = Math.sqrt(((SparseArray)instance.x()).valueStream().map(x -> x * x).sum());
            ((SparseArray)instance.x()).update((i, x) -> x / sum);
        });
    }

    public void unitize1() {
        this.stream().forEach(instance -> {
            double sum = ((SparseArray)instance.x()).valueStream().map(Math::abs).sum();
            ((SparseArray)instance.x()).update((i, x) -> x / sum);
        });
    }

    public SparseMatrix toMatrix() {
        int nz = this.nz();
        int ncol = this.ncol();
        int[] pos = new int[ncol];
        int[] colIndex = new int[ncol + 1];
        for (int i = 0; i < ncol; ++i) {
            colIndex[i + 1] = colIndex[i] + this.nz(i);
        }
        int nrow = this.size();
        int[] rowIndex = new int[nz];
        double[] x = new double[nz];
        for (int i = 0; i < nrow; ++i) {
            int row = i;
            ((SparseArray)this.get(i).x()).forEach((int j, double value) -> {
                int k = colIndex[j] + pos[j];
                rowIndex[k] = row;
                x[k] = value;
                int n = j;
                pos[n] = pos[n] + 1;
            });
        }
        return new SparseMatrix(nrow, ncol, x, rowIndex, colIndex);
    }

    public static SparseDataset<Void> of(SparseArray[] data) {
        return new SparseDataset<Void>(Arrays.stream(data).map(x -> new SampleInstance<SparseArray, Object>((SparseArray)x, null)).toList());
    }

    public static SparseDataset<Void> of(SparseArray[] data, int ncol) {
        return new SparseDataset<Void>(Arrays.stream(data).map(x -> new SampleInstance<SparseArray, Object>((SparseArray)x, null)).toList(), ncol);
    }

    public static SparseDataset<Void> from(Path path) throws IOException, ParseException {
        return SparseDataset.from(path, 0);
    }

    public static SparseDataset<Void> from(Path path, int arrayIndexOrigin) throws IOException, ParseException {
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));){
            Scanner scanner = new Scanner(reader);
            try {
                int nrow = scanner.nextInt();
                int ncol = scanner.nextInt();
                int nz = scanner.nextInt();
                SparseArray[] rows = new SparseArray[nrow];
                for (int i = 0; i < nrow; ++i) {
                    rows[i] = new SparseArray();
                }
                scanner.nextLine();
                do {
                    String line;
                    String[] tokens;
                    if ((tokens = (line = scanner.nextLine()).trim().split("\\s+")).length != 3) {
                        throw new ParseException("Invalid line: " + line, reader.getLineNumber());
                    }
                    int i = Integer.parseInt(tokens[0]) - arrayIndexOrigin;
                    int j = Integer.parseInt(tokens[1]) - arrayIndexOrigin;
                    double x = Double.parseDouble(tokens[2]);
                    SparseArray row = rows[i];
                    row.set(j, x);
                } while (scanner.hasNextLine());
                SparseDataset<Void> sparseDataset = SparseDataset.of(rows);
                scanner.close();
                return sparseDataset;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

