/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import smile.data.measure.CategoricalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.math.MathEx;
import smile.util.Index;

public class DoubleVector
extends PrimitiveVector {
    private final double[] vector;

    public DoubleVector(String name, double[] vector) {
        this(new StructField(name, DataTypes.DoubleType), vector);
    }

    public DoubleVector(StructField field, double[] vector) {
        super(field);
        if (field.dtype() != DataTypes.DoubleType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof CategoricalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        this.vector = vector;
    }

    public void fillna(double value) {
        for (int i = 0; i < this.vector.length; ++i) {
            if (!Double.isNaN(this.vector[i]) && !Double.isInfinite(this.vector[i])) continue;
            this.vector[i] = value;
        }
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public DoubleVector withName(String name) {
        return new DoubleVector(this.field.withName(name), this.vector);
    }

    @Override
    public DoubleStream doubleStream() {
        return Arrays.stream(this.vector);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Number n = (Number)value;
        this.vector[i] = n.doubleValue();
    }

    @Override
    public DoubleVector get(Index index) {
        double[] data = index.stream().mapToDouble(i -> this.vector[i]).toArray();
        return new DoubleVector(this.field, data);
    }

    @Override
    public boolean isNullAt(int i) {
        return Double.isNaN(this.vector[i]);
    }

    @Override
    public Double get(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return MathEx.isZero(this.vector[i]);
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return (int)this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return (long)this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return (float)this.vector[i];
    }
}

