/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.NullablePrimitiveVector;
import smile.util.Index;

public class NullableLongVector
extends NullablePrimitiveVector {
    private final long[] vector;

    public NullableLongVector(String name, long[] vector, BitSet nullMask) {
        this(new StructField(name, DataTypes.NullableLongType), vector, nullMask);
    }

    public NullableLongVector(StructField field, long[] vector, BitSet nullMask) {
        super(field, nullMask);
        if (field.dtype() != DataTypes.NullableLongType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public NullableLongVector withName(String name) {
        return new NullableLongVector(this.field.withName(name), this.vector, this.nullMask);
    }

    @Override
    public LongStream longStream() {
        return this.index().mapToLong(i -> this.nullMask.get(i) ? Long.MIN_VALUE : this.vector[i]);
    }

    @Override
    public DoubleStream doubleStream() {
        return this.longStream().mapToDouble(i -> i);
    }

    @Override
    public void set(int i, Object value) {
        if (value == null) {
            this.nullMask.set(i);
        } else if (value instanceof Number) {
            Number n = (Number)value;
            this.vector[i] = n.longValue();
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
    }

    @Override
    public NullableLongVector get(Index index) {
        int n = index.size();
        long[] data = new long[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int idx = index.apply(i);
            data[i] = this.vector[idx];
            mask.set(i, this.nullMask.get(idx));
        }
        return new NullableLongVector(this.field, data, mask);
    }

    @Override
    public Long get(int i) {
        return this.nullMask.get(i) ? null : Long.valueOf(this.vector[i]);
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] != 0L;
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return (int)this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

