/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.measure.OrdinalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.NullableBooleanVector;
import smile.data.vector.NullableByteVector;
import smile.data.vector.NullableCharVector;
import smile.data.vector.NullableDoubleVector;
import smile.data.vector.NullableFloatVector;
import smile.data.vector.NullableIntVector;
import smile.data.vector.NullableLongVector;
import smile.data.vector.NullableShortVector;
import smile.data.vector.NumberVector;
import smile.data.vector.ObjectVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.util.Index;

public interface ValueVector
extends Serializable {
    public StructField field();

    public int size();

    public ValueVector withName(String var1);

    default public String name() {
        return this.field().name();
    }

    default public DataType dtype() {
        return this.field().dtype();
    }

    default public Measure measure() {
        return this.field().measure();
    }

    public boolean isNullable();

    public boolean isNullAt(int var1);

    public int getNullCount();

    default public boolean[] eq(Object other) {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = other.equals(this.get(i));
        }
        return result;
    }

    default public boolean[] ne(Object other) {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = !other.equals(this.get(i));
        }
        return result;
    }

    default public <T extends Comparable<T>> boolean[] lt(T other) {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = other.compareTo((Comparable)((Comparable)this.get(i))) > 0;
        }
        return result;
    }

    default public <T extends Comparable<T>> boolean[] le(T other) {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = other.compareTo((Comparable)((Comparable)this.get(i))) >= 0;
        }
        return result;
    }

    default public <T extends Comparable<T>> boolean[] gt(T other) {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = other.compareTo((Comparable)((Comparable)this.get(i))) < 0;
        }
        return result;
    }

    default public <T extends Comparable<T>> boolean[] ge(T other) {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = other.compareTo((Comparable)((Comparable)this.get(i))) <= 0;
        }
        return result;
    }

    default public boolean anyNull() {
        return this.getNullCount() != 0;
    }

    default public boolean[] isNull() {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.isNullAt(i);
        }
        return result;
    }

    default public boolean[] isin(String ... values) {
        HashSet set = new HashSet();
        Collections.addAll(set, values);
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = set.contains(this.getString(i));
        }
        return result;
    }

    default public Stream<?> stream() {
        return this.intStream().mapToObj(this::get);
    }

    default public IntStream intStream() {
        throw new UnsupportedOperationException();
    }

    default public LongStream longStream() {
        return this.intStream().mapToLong(i -> i);
    }

    default public DoubleStream doubleStream() {
        return this.intStream().mapToDouble(i -> i);
    }

    default public int[] toIntArray() {
        return this.intStream().toArray();
    }

    default public long[] toLongArray() {
        return this.longStream().toArray();
    }

    default public double[] toDoubleArray() {
        return this.doubleStream().toArray();
    }

    default public String[] toStringArray() {
        return this.toStringArray(new String[this.size()]);
    }

    default public String[] toStringArray(String[] a) {
        int n = Math.min(a.length, this.size());
        StructField field = this.field();
        for (int i = 0; i < n; ++i) {
            a[i] = field.toString(this.get(i));
        }
        return a;
    }

    public Object get(int var1);

    default public Object apply(int i) {
        return this.get(i);
    }

    public void set(int var1, Object var2);

    default public void update(int i, Object value) {
        this.set(i, value);
    }

    public ValueVector get(Index var1);

    default public ValueVector get(int ... indices) {
        return this.get(Index.of(indices));
    }

    default public ValueVector apply(int ... indices) {
        return this.get(indices);
    }

    default public ValueVector slice(int start, int end) {
        return this.slice(start, end, 1);
    }

    default public ValueVector slice(int start, int end, int step) {
        return this.get(Index.range(start, end, step));
    }

    default public String getString(int i) {
        return this.field().toString(this.get(i));
    }

    default public String getScale(int i) {
        int x = this.getInt(i);
        Measure measure = this.measure();
        if (measure instanceof CategoricalMeasure) {
            CategoricalMeasure cat = (CategoricalMeasure)measure;
            return cat.toString(x);
        }
        return String.valueOf(x);
    }

    public boolean getBoolean(int var1);

    public char getChar(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public static BooleanVector of(String name, boolean ... vector) {
        return new BooleanVector(name, vector);
    }

    public static NullableBooleanVector ofNullable(String name, Boolean ... vector) {
        int n = vector.length;
        boolean[] data = new boolean[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                continue;
            }
            data[i] = vector[i];
        }
        return new NullableBooleanVector(name, data, mask);
    }

    public static CharVector of(String name, char ... vector) {
        return new CharVector(name, vector);
    }

    public static NullableCharVector ofNullable(String name, Character ... vector) {
        int n = vector.length;
        char[] data = new char[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = '\u0000';
                continue;
            }
            data[i] = vector[i].charValue();
        }
        return new NullableCharVector(name, data, mask);
    }

    public static ByteVector of(String name, byte ... vector) {
        return new ByteVector(name, vector);
    }

    public static NullableByteVector ofNullable(String name, Byte ... vector) {
        int n = vector.length;
        byte[] data = new byte[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = -128;
                continue;
            }
            data[i] = vector[i];
        }
        return new NullableByteVector(name, data, mask);
    }

    public static ShortVector of(String name, short ... vector) {
        return new ShortVector(name, vector);
    }

    public static NullableShortVector ofNullable(String name, Short ... vector) {
        int n = vector.length;
        short[] data = new short[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = Short.MIN_VALUE;
                continue;
            }
            data[i] = vector[i];
        }
        return new NullableShortVector(name, data, mask);
    }

    public static IntVector of(String name, int ... vector) {
        return new IntVector(name, vector);
    }

    public static NullableIntVector ofNullable(String name, Integer ... vector) {
        int n = vector.length;
        int[] data = new int[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = Integer.MIN_VALUE;
                continue;
            }
            data[i] = vector[i];
        }
        return new NullableIntVector(name, data, mask);
    }

    public static LongVector of(String name, long ... vector) {
        return new LongVector(name, vector);
    }

    public static NullableLongVector ofNullable(String name, Long ... vector) {
        int n = vector.length;
        long[] data = new long[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = Long.MIN_VALUE;
                continue;
            }
            data[i] = vector[i];
        }
        return new NullableLongVector(name, data, mask);
    }

    public static FloatVector of(String name, float ... vector) {
        return new FloatVector(name, vector);
    }

    public static NullableFloatVector ofNullable(String name, Float ... vector) {
        int n = vector.length;
        float[] data = new float[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = Float.NaN;
                continue;
            }
            data[i] = vector[i].floatValue();
        }
        return new NullableFloatVector(name, data, mask);
    }

    public static DoubleVector of(String name, double ... vector) {
        return new DoubleVector(name, vector);
    }

    public static NullableDoubleVector ofNullable(String name, Double ... vector) {
        int n = vector.length;
        double[] data = new double[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (vector[i] == null) {
                mask.set(i);
                data[i] = Double.NaN;
                continue;
            }
            data[i] = vector[i];
        }
        return new NullableDoubleVector(name, data, mask);
    }

    public static StringVector of(String name, String ... vector) {
        return new StringVector(name, vector);
    }

    public static NumberVector<BigDecimal> of(String name, BigDecimal ... vector) {
        StructField field = new StructField(name, DataTypes.DecimalType);
        return new NumberVector(field, (Number[])vector);
    }

    public static ObjectVector<Timestamp> of(String name, Timestamp ... vector) {
        StructField field = new StructField(name, DataTypes.DateTimeType);
        return new ObjectVector<Timestamp>(field, vector);
    }

    public static ObjectVector<Instant> of(String name, Instant ... vector) {
        StructField field = new StructField(name, DataTypes.DateTimeType);
        return new ObjectVector<Instant>(field, vector);
    }

    public static ObjectVector<LocalDateTime> of(String name, LocalDateTime ... vector) {
        StructField field = new StructField(name, DataTypes.DateTimeType);
        return new ObjectVector<LocalDateTime>(field, vector);
    }

    public static ObjectVector<ZonedDateTime> of(String name, ZonedDateTime ... vector) {
        StructField field = new StructField(name, DataTypes.DateTimeType);
        return new ObjectVector<ZonedDateTime>(field, vector);
    }

    public static ObjectVector<LocalDate> of(String name, LocalDate ... vector) {
        StructField field = new StructField(name, DataTypes.DateType);
        return new ObjectVector<LocalDate>(field, vector);
    }

    public static ObjectVector<LocalTime> of(String name, LocalTime ... vector) {
        StructField field = new StructField(name, DataTypes.TimeType);
        return new ObjectVector<LocalTime>(field, vector);
    }

    public static ObjectVector<OffsetTime> of(String name, OffsetTime ... vector) {
        StructField field = new StructField(name, DataTypes.TimeType);
        return new ObjectVector<OffsetTime>(field, vector);
    }

    public static ValueVector nominal(String name, Enum<?> ... vector) {
        Class<?> clazz = vector.getClass().getComponentType();
        ?[] values = clazz.getEnumConstants();
        DataType dtype = DataTypes.category(values.length);
        NominalScale measure = new NominalScale(clazz);
        StructField field = new StructField(name, dtype, measure);
        return ValueVector.category(field, vector);
    }

    public static ValueVector nominal(String name, String ... vector) {
        TreeSet values = new TreeSet();
        Collections.addAll(values, vector);
        DataType dtype = DataTypes.category(values.size());
        NominalScale measure = new NominalScale(values.toArray(new String[0]));
        StructField field = new StructField(name, dtype, measure);
        return ValueVector.category(field, vector);
    }

    public static ValueVector ordinal(String name, Enum<?> ... vector) {
        Class<?> clazz = vector.getClass().getComponentType();
        ?[] values = clazz.getEnumConstants();
        DataType dtype = DataTypes.category(values.length);
        OrdinalScale measure = new OrdinalScale(clazz);
        StructField field = new StructField(name, dtype, measure);
        return ValueVector.category(field, vector);
    }

    public static ValueVector ordinal(String name, String ... vector) {
        TreeSet values = new TreeSet();
        Collections.addAll(values, vector);
        DataType dtype = DataTypes.category(values.size());
        OrdinalScale measure = new OrdinalScale(values.toArray(new String[0]));
        StructField field = new StructField(name, dtype, measure);
        return ValueVector.category(field, vector);
    }

    private static ValueVector category(StructField field, Enum<?>[] vector) {
        int n = vector.length;
        DataType dtype = field.dtype();
        Measure measure = field.measure();
        return switch (dtype.id()) {
            case DataType.ID.Byte -> {
                byte[] data = new byte[n];
                for (int i = 0; i < n; ++i) {
                    data[i] = (byte)vector[i].ordinal();
                }
                yield new ByteVector(field, data);
            }
            case DataType.ID.Short -> {
                short[] data = new short[n];
                for (int i = 0; i < n; ++i) {
                    data[i] = (short)vector[i].ordinal();
                }
                yield new ShortVector(field, data);
            }
            case DataType.ID.Int -> {
                int[] data = new int[n];
                for (int i = 0; i < n; ++i) {
                    data[i] = vector[i].ordinal();
                }
                yield new IntVector(field, data);
            }
            default -> throw new IllegalStateException("Invalid categorical data type: " + String.valueOf(dtype));
        };
    }

    private static ValueVector category(StructField field, String[] vector) {
        int n = vector.length;
        DataType dtype = field.dtype();
        Measure measure = field.measure();
        return switch (field.dtype().id()) {
            case DataType.ID.Byte -> {
                byte[] data = new byte[n];
                for (int i = 0; i < n; ++i) {
                    data[i] = (Byte)measure.valueOf(vector[i]);
                }
                yield new ByteVector(field, data);
            }
            case DataType.ID.Short -> {
                short[] data = new short[n];
                for (int i = 0; i < n; ++i) {
                    data[i] = (Short)measure.valueOf(vector[i]);
                }
                yield new ShortVector(field, data);
            }
            case DataType.ID.Int -> {
                int[] data = new int[n];
                for (int i = 0; i < n; ++i) {
                    data[i] = (Integer)measure.valueOf(vector[i]);
                }
                yield new IntVector(field, data);
            }
            default -> throw new IllegalStateException("Invalid categorical data type: " + String.valueOf(dtype));
        };
    }
}

