/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.util.Arrays;
import java.util.Iterator;
import smile.math.distance.Metric;
import smile.util.SparseArray;

public class SparseMinkowskiDistance
implements Metric<SparseArray> {
    private static final long serialVersionUID = 1L;
    private final int p;
    private final double[] weight;

    public SparseMinkowskiDistance(int p) {
        this(p, null);
    }

    public SparseMinkowskiDistance(int p, double[] weight) {
        if (p <= 0) {
            throw new IllegalArgumentException(String.format("The order p has to be larger than 0: p = %d", p));
        }
        if (weight != null) {
            for (double w : weight) {
                if (!(w < 0.0)) continue;
                throw new IllegalArgumentException(String.format("Weight has to be non-negative: %f", w));
            }
        }
        this.p = p;
        this.weight = weight;
    }

    public String toString() {
        if (this.weight != null) {
            return String.format("Weighted Minkowski Distance(p = %d, weight = %s)", this.p, Arrays.toString(this.weight));
        }
        return String.format("Minkowski Distance(p = %d)", this.p);
    }

    @Override
    public double d(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double dist = 0.0;
        if (this.weight == null) {
            double d;
            while (a != null && b != null) {
                if (a.index() < b.index()) {
                    d = a.value();
                    dist += Math.pow(d, this.p);
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.index() > b.index()) {
                    d = b.value();
                    dist += Math.pow(d, this.p);
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                d = a.value() - b.value();
                dist += Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                d = a.value();
                dist += Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                d = b.value();
                dist += Math.pow(d, this.p);
                b = iterY.hasNext() ? iterY.next() : null;
            }
        } else {
            double d;
            while (a != null && b != null) {
                if (a.index() < b.index()) {
                    d = a.value();
                    dist += this.weight[a.index()] * Math.pow(d, this.p);
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.index() > b.index()) {
                    d = b.value();
                    dist += this.weight[b.index()] * Math.pow(d, this.p);
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                d = a.value() - b.value();
                dist += this.weight[a.index()] * Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                d = a.value();
                dist += this.weight[a.index()] * Math.pow(d, this.p);
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                d = b.value();
                dist += this.weight[b.index()] * Math.pow(d, this.p);
                b = iterY.hasNext() ? iterY.next() : null;
            }
        }
        return Math.pow(dist, 1.0 / (double)this.p);
    }
}

