/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.matrix.IMatrix;

public class PageRank {
    private static final Logger logger = LoggerFactory.getLogger(PageRank.class);

    private PageRank() {
    }

    public static double[] of(IMatrix A) {
        int n = A.nrow();
        double[] v = new double[n];
        Arrays.fill(v, 1.0 / (double)n);
        return PageRank.of(A, v);
    }

    public static double[] of(IMatrix A, double[] v) {
        return PageRank.of(A, v, 0.85, 1.0E-7, 57);
    }

    public static double[] of(IMatrix A, double[] v, double damping, double tol, int maxIter) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException("Matrix is not square.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int n = A.nrow();
        tol = Math.max(tol, MathEx.EPSILON * (double)n);
        double[] z = new double[n];
        double[] p = Arrays.copyOf(v, n);
        for (int iter = 1; iter <= maxIter; ++iter) {
            A.mv(p, z);
            double beta = 1.0 - damping * MathEx.norm1(z);
            double delta = 0.0;
            for (int i = 0; i < n; ++i) {
                double q = damping * z[i] + beta * v[i];
                delta += Math.abs(q - p[i]);
                p[i] = q;
            }
            if (iter % 10 == 0 || delta < tol) {
                logger.info("PageRank residual after {} power iterations: {}", (Object)iter, (Object)delta);
            }
            if (!(delta < tol)) continue;
            return p;
        }
        logger.error("PageRank iteration exceeded the maximum number of iterations.");
        return p;
    }
}

