/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

public interface Sort {
    public static void swap(int[] a, int i, int j) {
        int temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static void swap(float[] a, int i, int j) {
        float temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static void swap(double[] a, int i, int j) {
        double temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static void swap(Object[] a, int i, int j) {
        Object temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static void siftUp(int[] a, int k) {
        while (k > 1 && a[k / 2] < a[k]) {
            Sort.swap(a, k, k / 2);
            k /= 2;
        }
    }

    public static void siftUp(float[] a, int k) {
        while (k > 1 && a[k / 2] < a[k]) {
            Sort.swap(a, k, k / 2);
            k /= 2;
        }
    }

    public static void siftUp(double[] a, int k) {
        while (k > 1 && a[k / 2] < a[k]) {
            Sort.swap(a, k, k / 2);
            k /= 2;
        }
    }

    public static <T extends Comparable<? super T>> void siftUp(T[] a, int k) {
        while (k > 1 && a[k / 2].compareTo(a[k]) < 0) {
            Sort.swap(a, k, k / 2);
            k /= 2;
        }
    }

    public static void siftDown(int[] a, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && a[j] < a[j + 1]) {
                ++j;
            }
            if (a[k] >= a[j]) break;
            Sort.swap(a, k, j);
            k = j;
        }
    }

    public static void siftDown(float[] a, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && a[j] < a[j + 1]) {
                ++j;
            }
            if (a[k] >= a[j]) break;
            Sort.swap(a, k, j);
            k = j;
        }
    }

    public static void siftDown(double[] a, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && a[j] < a[j + 1]) {
                ++j;
            }
            if (a[k] >= a[j]) break;
            Sort.swap(a, k, j);
            k = j;
        }
    }

    public static <T extends Comparable<? super T>> void siftDown(T[] a, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && a[j].compareTo(a[j + 1]) < 0) {
                ++j;
            }
            if (a[k].compareTo(a[j]) >= 0) break;
            Sort.swap(a, k, j);
            k = j;
        }
    }
}

