/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScope
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AutoScope.class);
    private final List<AutoCloseable> resources = new LinkedList<AutoCloseable>();

    public AutoScope(AutoCloseable ... resources) {
        for (AutoCloseable resource : resources) {
            this.add(resource);
        }
    }

    public <T extends AutoCloseable> T add(T resource) {
        this.resources.add(resource);
        return resource;
    }

    public void remove(AutoCloseable resource) {
        this.resources.remove(resource);
    }

    @Override
    public void close() {
        for (AutoCloseable resource : this.resources) {
            try {
                resource.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.resources.clear();
    }
}

