/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;

public class SQL
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SQL.class);
    private final Connection db;

    public SQL() throws SQLException {
        this.db = DriverManager.getConnection("jdbc:duckdb:");
    }

    public SQL(String path) throws SQLException {
        this.db = DriverManager.getConnection("jdbc:duckdb:" + path);
    }

    public String toString() {
        try {
            return String.format("SQL(%s)", this.db.getCatalog());
        }
        catch (SQLException ex) {
            return "SQL(memory)";
        }
    }

    @Override
    public void close() throws SQLException {
        this.db.close();
    }

    public DataFrame tables() throws SQLException {
        DatabaseMetaData meta = this.db.getMetaData();
        try (ResultSet rs = meta.getTables(null, null, null, null);){
            DataFrame df = DataFrame.of(rs);
            DataFrame dataFrame = df.select("TABLE_NAME", "REMARKS");
            return dataFrame;
        }
    }

    public DataFrame describe(String table) throws SQLException {
        DatabaseMetaData meta = this.db.getMetaData();
        try (ResultSet rs = meta.getColumns(null, null, table, null);){
            DataFrame df = DataFrame.of(rs);
            DataFrame dataFrame = df.select("COLUMN_NAME", "TYPE_NAME", "IS_NULLABLE");
            return dataFrame;
        }
    }

    public SQL csv(String name, String ... path) throws SQLException {
        return this.csv(name, ',', null, path);
    }

    public SQL csv(String name, char delimiter, Map<String, String> columns, String ... path) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CREATE TABLE %s AS\nSELECT * FROM read_csv(%s,delim='%c',", name, this.fileList(path), Character.valueOf(delimiter)));
        if (columns == null) {
            sb.append("header=true");
        } else {
            sb.append("columns=");
            sb.append(this.columnList(columns));
        }
        sb.append(')');
        String query = sb.toString();
        logger.info(query);
        try (Statement stmt = this.db.createStatement();){
            stmt.execute(query);
        }
        return this;
    }

    public SQL parquet(String name, String ... path) throws SQLException {
        return this.parquet(name, (Map<String, String>)null, path);
    }

    public SQL parquet(String name, Map<String, String> options, String ... path) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CREATE TABLE %s AS\nSELECT * FROM read_parquet(%s", name, this.fileList(path)));
        if (options != null) {
            sb.append(", ");
            sb.append(this.optionList(options));
        }
        sb.append(')');
        String query = sb.toString();
        logger.info(query);
        try (Statement stmt = this.db.createStatement();){
            stmt.execute(query);
        }
        return this;
    }

    public SQL json(String name, String ... path) throws SQLException {
        return this.json(name, "auto", (Map<String, String>)null, path);
    }

    public SQL json(String name, String format, Map<String, String> columns, String ... path) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CREATE TABLE %s AS\nSELECT * FROM read_json(%s, format = '%s'", name, this.fileList(path), format));
        if (columns != null) {
            sb.append(", columns = ");
            sb.append(this.columnList(columns));
        }
        sb.append(')');
        String query = sb.toString();
        logger.info(query);
        try (Statement stmt = this.db.createStatement();){
            stmt.execute(query);
        }
        return this;
    }

    private String fileList(String ... path) {
        return Arrays.stream(path).map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    }

    private String columnList(Map<String, String> columns) {
        return columns.keySet().stream().map(key -> String.format("'%s': '%s'", key, columns.get(key))).collect(Collectors.joining(", ", "{", "}"));
    }

    private String optionList(Map<String, String> options) {
        return options.keySet().stream().map(key -> String.format("%s = %s", key, options.get(key))).collect(Collectors.joining(", "));
    }

    public DataFrame query(String sql) throws SQLException {
        logger.info(sql);
        try (Statement stmt = this.db.createStatement();){
            DataFrame dataFrame = DataFrame.of(stmt.executeQuery(sql));
            return dataFrame;
        }
    }

    public int update(String sql) throws SQLException {
        logger.info(sql);
        try (Statement stmt = this.db.createStatement();){
            int n = stmt.executeUpdate(sql);
            return n;
        }
    }

    public boolean execute(String sql) throws SQLException {
        logger.info(sql);
        try (Statement stmt = this.db.createStatement();){
            boolean bl = stmt.execute(sql);
            return bl;
        }
    }

    static {
        try {
            Class.forName("org.duckdb.DuckDBDriver");
        }
        catch (ClassNotFoundException ex) {
            logger.error("Failed to load DuckDB driver: ", (Throwable)ex);
        }
    }
}

