/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.util.Index;

public class LongVector
extends PrimitiveVector {
    private final long[] vector;

    public LongVector(String name, long[] vector) {
        this(new StructField(name, DataTypes.LongType), vector);
    }

    public LongVector(StructField field, long[] vector) {
        super(field);
        if (field.dtype() != DataTypes.LongType) {
            throw new IllegalArgumentException("Invalid data type: ");
        }
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public LongVector withName(String name) {
        return new LongVector(this.field.withName(name), this.vector);
    }

    @Override
    public LongStream longStream() {
        return Arrays.stream(this.vector);
    }

    @Override
    public DoubleStream doubleStream() {
        return this.longStream().mapToDouble(i -> i);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Number n = (Number)value;
        this.vector[i] = n.longValue();
    }

    @Override
    public LongVector get(Index index) {
        long[] data = index.stream().mapToLong(i -> this.vector[i]).toArray();
        return new LongVector(this.field, data);
    }

    @Override
    public Long get(int i) {
        return this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] != 0L;
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return (int)this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

