/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.stat.distribution.MultivariateGaussianDistribution;

public record GaussianMixture(double[][] x, int[] y) {
    public static GaussianMixture generate() {
        MathEx.setSeed(19650218L);
        double[][] x = new double[10000][];
        int[] y = new int[10000];
        double[] mu1 = new double[]{1.0, 1.0, 1.0};
        double[][] sigma1 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[] mu2 = new double[]{-2.0, -2.0, -2.0};
        double[][] sigma2 = new double[][]{{1.0, 0.3, 0.8}, {0.3, 1.0, 0.5}, {0.8, 0.5, 1.0}};
        double[] mu3 = new double[]{4.0, 2.0, 3.0};
        double[][] sigma3 = new double[][]{{1.0, 0.8, 0.3}, {0.8, 1.0, 0.5}, {0.3, 0.5, 1.0}};
        double[] mu4 = new double[]{3.0, 5.0, 1.0};
        double[][] sigma4 = new double[][]{{1.0, 0.5, 0.5}, {0.5, 1.0, 0.5}, {0.5, 0.5, 1.0}};
        MultivariateGaussianDistribution g1 = new MultivariateGaussianDistribution(mu1, Matrix.of(sigma1));
        for (int i = 0; i < 2000; ++i) {
            x[i] = g1.rand();
            y[i] = 0;
        }
        MultivariateGaussianDistribution g2 = new MultivariateGaussianDistribution(mu2, Matrix.of(sigma2));
        for (int i = 0; i < 3000; ++i) {
            x[2000 + i] = g2.rand();
            y[i] = 1;
        }
        MultivariateGaussianDistribution g3 = new MultivariateGaussianDistribution(mu3, Matrix.of(sigma3));
        for (int i = 0; i < 3000; ++i) {
            x[5000 + i] = g3.rand();
            y[i] = 2;
        }
        MultivariateGaussianDistribution g4 = new MultivariateGaussianDistribution(mu4, Matrix.of(sigma4));
        for (int i = 0; i < 2000; ++i) {
            x[8000 + i] = g4.rand();
            y[i] = 3;
        }
        return new GaussianMixture(x, y);
    }
}

