/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.io.Paths;
import smile.io.Read;

public record ProstateCancer(DataFrame train, DataFrame test, Formula formula) {
    public ProstateCancer() throws IOException {
        this(Paths.getTestData("regression/prostate-train.csv"), Paths.getTestData("regression/prostate-test.csv"));
    }

    public ProstateCancer(Path trainDataPath, Path testDataPath) throws IOException {
        this(ProstateCancer.load(trainDataPath), ProstateCancer.load(testDataPath), Formula.lhs("lpsa"));
    }

    private static DataFrame load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setDelimiter('\t').setHeader(new String[0]).setSkipHeaderRecord(true).get();
        return Read.csv(path, format);
    }

    public double[][] x() {
        return this.formula.x(this.train).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public double[] y() {
        return this.formula.y(this.train).toDoubleArray();
    }

    public double[][] testx() {
        return this.formula.x(this.test).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public double[] testy() {
        return this.formula.y(this.test).toDoubleArray();
    }
}

