/*
 * Decompiled with CFR 0.152.
 */
package smile.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.stream.DoubleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.VertexVisitor;
import smile.math.MathEx;
import smile.math.matrix.IMatrix;
import smile.sort.Sort;
import smile.util.PriorityQueue;
import smile.util.Strings;
import smile.util.function.ArrayElementConsumer;
import smile.util.function.ArrayElementFunction;

public abstract class Graph {
    private static final Logger logger = LoggerFactory.getLogger(Graph.class);
    private final boolean digraph;

    public Graph(boolean digraph) {
        this.digraph = digraph;
    }

    public boolean isDigraph() {
        return this.digraph;
    }

    public String dot() {
        return this.dot(null, null);
    }

    public String dot(String name, String[] label) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.digraph ? "digraph " : "graph ");
        if (name != null) {
            builder.append(name);
        }
        builder.append(" {\n");
        builder.append("  node [shape=box, style=\"rounded\", color=\"black\", fontname=helvetica];\n");
        builder.append("  edge [fontname=helvetica];\n");
        if (label != null) {
            for (int i = 0; i < label.length; ++i) {
                builder.append(String.format("  %d [label=\"%s\"];\n", i, label[i]));
            }
        }
        int n = this.getVertexCount();
        String edge = this.digraph ? "->" : "--";
        for (int i = 0; i < n; ++i) {
            int u = i;
            this.forEachEdge(i, (v, w) -> {
                if (this.digraph || v >= u) {
                    builder.append(String.format("  %d %s %d [label=\"%s\"];\n", u, edge, v, Strings.format(w)));
                }
            });
        }
        builder.append("}");
        return builder.toString();
    }

    public abstract IMatrix toMatrix();

    public abstract Graph subgraph(int[] var1);

    public abstract int getVertexCount();

    public abstract boolean hasEdge(int var1, int var2);

    public abstract double getWeight(int var1, int var2);

    public double getDistance(int source, int target) {
        double weight = this.getWeight(source, target);
        return weight == 0.0 ? Double.POSITIVE_INFINITY : weight;
    }

    public abstract Graph setWeight(int var1, int var2, double var3);

    public abstract List<Edge> getEdges(int var1);

    public abstract void forEachEdge(int var1, ArrayElementConsumer var2);

    public abstract DoubleStream mapEdges(int var1, ArrayElementFunction var2);

    public abstract void updateEdges(int var1, ArrayElementFunction var2);

    public Graph addEdge(int source, int target) {
        return this.addEdge(source, target, 1.0);
    }

    public Graph addEdge(int source, int target, double weight) {
        return this.setWeight(source, target, weight);
    }

    public Graph addEdges(Collection<Edge> edges) {
        for (Edge edge : edges) {
            this.setWeight(edge.u, edge.v, edge.weight);
        }
        return this;
    }

    public Graph removeEdges(Collection<Edge> edges) {
        for (Edge edge : edges) {
            this.removeEdge(edge.u, edge.v);
        }
        return this;
    }

    public Graph removeEdge(int source, int target) {
        return this.setWeight(source, target, 0.0);
    }

    public int getDegree(int vertex) {
        return this.digraph ? this.getInDegree(vertex) + this.getOutDegree(vertex) : this.getOutDegree(vertex);
    }

    public abstract int getInDegree(int var1);

    public abstract int getOutDegree(int var1);

    private void dfsort(int v, boolean[] visited, int[] order, int[] count) {
        visited[v] = true;
        this.forEachEdge(v, (u, w) -> {
            if (!visited[u]) {
                this.dfsort(u, visited, order, count);
            }
        });
        int n = count[0];
        count[0] = n + 1;
        order[n] = v;
    }

    public int[] dfsort() {
        if (!this.digraph) {
            throw new UnsupportedOperationException("Topological sort cannot be applied on undirected graph.");
        }
        int n = this.getVertexCount();
        boolean[] visited = new boolean[n];
        int[] order = new int[n];
        Arrays.fill(order, -1);
        int[] count = new int[1];
        for (int i = 0; i < n; ++i) {
            if (visited[i]) continue;
            this.dfsort(i, visited, order, count);
        }
        return order;
    }

    private void dfcc(int v, int[] cc, int id) {
        cc[v] = id;
        this.forEachEdge(v, (u, w) -> {
            if (cc[u] == -1) {
                this.dfcc(u, cc, id);
            }
        });
    }

    public int[][] dfcc() {
        if (this.digraph) {
            throw new UnsupportedOperationException("Connected components algorithm cannot be applied on digraph");
        }
        int n = this.getVertexCount();
        int[] cc = new int[n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < n; ++i) {
            if (cc[i] != -1) continue;
            this.dfcc(i, cc, id++);
        }
        return this.connectedComponents(id, cc);
    }

    private int[][] connectedComponents(int numComponents, int[] cc) {
        int n = cc.length;
        int[] size = new int[numComponents];
        int[] nArray = cc;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int c;
            int n3 = c = nArray[i];
            size[n3] = size[n3] + 1;
        }
        int[][] components = new int[numComponents][];
        for (int i = 0; i < numComponents; ++i) {
            components[i] = new int[size[i]];
            int k = 0;
            for (int j = 0; j < n; ++j) {
                if (cc[j] != i) continue;
                components[i][k++] = j;
            }
            Arrays.sort(components[i]);
        }
        return components;
    }

    private void dfs(VertexVisitor visitor, int v, boolean[] visited) {
        visitor.accept(v);
        visited[v] = true;
        this.forEachEdge(v, (u, w) -> {
            if (!visited[u]) {
                this.dfs(visitor, u, visited);
            }
        });
    }

    public void dfs(VertexVisitor visitor) {
        int n = this.getVertexCount();
        boolean[] visited = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (visited[i]) continue;
            this.dfs(visitor, i, visited);
        }
    }

    public int[] bfsort() {
        int i;
        if (!this.digraph) {
            throw new UnsupportedOperationException("Topological sort cannot be applied on undirected graph.");
        }
        int n = this.getVertexCount();
        int[] in = new int[n];
        int[] ts = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ts[i2] = -1;
            this.forEachEdge(i2, (j, w) -> {
                int n = j;
                in[n] = in[n] + 1;
            });
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (i = 0; i < n; ++i) {
            if (in[i] != 0) continue;
            queue.offer(i);
        }
        i = 0;
        while (!queue.isEmpty()) {
            int u;
            ts[i] = u = ((Integer)queue.poll()).intValue();
            this.forEachEdge(u, (v, w) -> {
                int n = v;
                in[n] = in[n] - 1;
                if (in[n] == 0) {
                    queue.offer(v);
                }
            });
            ++i;
        }
        return ts;
    }

    private void bfcc(int v, int[] cc, int id) {
        cc[v] = id;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(v);
        while (!queue.isEmpty()) {
            int u = (Integer)queue.poll();
            this.forEachEdge(u, (i, w) -> {
                if (cc[i] == -1) {
                    queue.offer(i);
                    cc[i] = id;
                }
            });
        }
    }

    public int[][] bfcc() {
        if (this.digraph) {
            throw new UnsupportedOperationException("Connected components algorithm cannot be applied on digraph");
        }
        int n = this.getVertexCount();
        int[] cc = new int[n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < n; ++i) {
            if (cc[i] != -1) continue;
            this.bfcc(i, cc, id++);
        }
        return this.connectedComponents(id, cc);
    }

    private void bfs(VertexVisitor visitor, int v, boolean[] visited, Queue<Integer> queue) {
        visitor.accept(v);
        visited[v] = true;
        queue.offer(v);
        while (!queue.isEmpty()) {
            int u = queue.poll();
            this.forEachEdge(u, (i, w) -> {
                if (!visited[i]) {
                    visitor.accept(i);
                    queue.offer(i);
                    visited[i] = true;
                }
            });
        }
    }

    public void bfs(VertexVisitor visitor) {
        int n = this.getVertexCount();
        boolean[] visited = new boolean[n];
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (visited[i]) continue;
            this.bfs(visitor, i, visited, queue);
        }
    }

    public double[] dijkstra(int s) {
        return this.dijkstra(s, true);
    }

    public double[] dijkstra(int s, boolean weighted) {
        int v;
        int n = this.getVertexCount();
        double[] wt = new double[n];
        Arrays.fill(wt, Double.POSITIVE_INFINITY);
        PriorityQueue queue = new PriorityQueue(wt);
        for (v = 0; v < n; ++v) {
            queue.insert(v);
        }
        wt[s] = 0.0;
        queue.lower(s);
        while (!queue.isEmpty()) {
            v = queue.poll();
            if (Double.isInfinite(wt[v])) continue;
            this.forEachEdge(v, (u, weight) -> {
                double p = wt[v] + (weighted ? weight : 1.0);
                if (p < wt[u]) {
                    wt[u] = p;
                    queue.lower(u);
                }
            });
        }
        return wt;
    }

    public double[][] dijkstra() {
        int n = this.getVertexCount();
        double[][] wt = new double[n][];
        for (int i = 0; i < n; ++i) {
            wt[i] = this.dijkstra(i);
        }
        return wt;
    }

    public double prim(List<Edge> mst) {
        int u;
        if (this.digraph) {
            throw new UnsupportedOperationException("Prim's algorithm cannot be applied on a digraph.");
        }
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct MST with fewer than 2 vertices.");
        }
        boolean[] inMST = new boolean[n];
        double[] minEdgeWeight = new double[n];
        Arrays.fill(minEdgeWeight, Double.MAX_VALUE);
        int[] parent = new int[n];
        Arrays.fill(parent, -1);
        double totalWeight = 0.0;
        minEdgeWeight[0] = 0.0;
        for (int i = 0; i < n; ++i) {
            u = -1;
            double minWeight = Double.MAX_VALUE;
            for (int v2 = 0; v2 < n; ++v2) {
                if (inMST[v2] || !(minEdgeWeight[v2] < minWeight)) continue;
                minWeight = minEdgeWeight[v2];
                u = v2;
            }
            if (u == -1) {
                throw new RuntimeException("Failed to construct MST");
            }
            inMST[u] = true;
            totalWeight += minWeight;
            int p = u;
            this.forEachEdge(u, (v, weight) -> {
                if (!inMST[v] && weight < minEdgeWeight[v]) {
                    minEdgeWeight[v] = weight;
                    parent[v] = p;
                }
            });
        }
        if (mst != null) {
            for (int v3 = 1; v3 < n; ++v3) {
                if (parent[v3] == -1) continue;
                u = parent[v3];
                mst.add(new Edge(v3, u, minEdgeWeight[v3]));
            }
        }
        return totalWeight;
    }

    public double getPathDistance(int[] path) {
        double distance = 0.0;
        for (int i = 0; i < path.length - 1; ++i) {
            distance += this.getDistance(path[i], path[i + 1]);
        }
        return distance;
    }

    private void swapEdges(int[] path, int i, int j) {
        ++i;
        while (i < j) {
            Sort.swap(path, i, j);
            ++i;
            --j;
        }
    }

    private double mstLowerBound(boolean[] inPath) {
        int i;
        int n = this.getVertexCount();
        boolean[] inMST = new boolean[n];
        double[] minEdgeWeight = new double[n];
        Arrays.fill(minEdgeWeight, Double.MAX_VALUE);
        double totalWeight = 0.0;
        for (i = 0; i < n; ++i) {
            if (inPath[i]) continue;
            minEdgeWeight[i] = 0.0;
            break;
        }
        for (i = 0; i < n; ++i) {
            int u = -1;
            double minWeight = Double.MAX_VALUE;
            for (int v2 = 0; v2 < n; ++v2) {
                if (inMST[v2] || inPath[v2] || !(minEdgeWeight[v2] < minWeight)) continue;
                minWeight = minEdgeWeight[v2];
                u = v2;
            }
            if (u == -1) break;
            inMST[u] = true;
            totalWeight += minWeight;
            int p = u;
            this.forEachEdge(u, (v, weight) -> {
                if (!inMST[v] && !inPath[v]) {
                    minEdgeWeight[v] = Math.min(minEdgeWeight[v], weight);
                }
            });
        }
        this.forEachEdge(0, (v, weight) -> {
            if (inMST[v]) {
                minEdgeWeight[0] = Math.min(minEdgeWeight[0], weight);
            }
        });
        return totalWeight + minEdgeWeight[0];
    }

    public int[] tsp() {
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct TSP with fewer than 2 vertices.");
        }
        int[] tour = this.nearestInsertion();
        double bestCost = this.getPathDistance(tour);
        java.util.PriorityQueue<TspNode> pq = new java.util.PriorityQueue<TspNode>();
        pq.offer(new TspNode(new int[1], 0.0, 0.0));
        while (!pq.isEmpty()) {
            TspNode current = (TspNode)pq.poll();
            if (current.lowerBound >= bestCost) continue;
            if (current.level() == n) {
                double cost = current.cost + this.getDistance(current.path[n - 1], 0);
                if (!(cost < bestCost)) continue;
                bestCost = cost;
                System.arraycopy(current.path, 0, tour, 0, n);
                continue;
            }
            boolean[] inPath = new boolean[n];
            for (int node : current.path) {
                inPath[node] = true;
            }
            double mst = n - current.level() < 5 ? 0.0 : this.mstLowerBound(inPath);
            double currentBest = bestCost;
            this.forEachEdge(current.path[current.level() - 1], (v, weight) -> {
                if (inPath[v]) {
                    return;
                }
                double nextCost = current.cost + weight;
                double nextLowerBound = nextCost + mst;
                if (nextLowerBound < currentBest) {
                    int[] nextPath = Arrays.copyOfRange(current.path, 0, current.level() + 1);
                    nextPath[current.level()] = v;
                    pq.offer(new TspNode(nextPath, nextLowerBound, nextCost));
                }
            });
        }
        logger.info("Branch and bound TSP cost = {}", (Object)bestCost);
        return tour;
    }

    public int[] heldKarp() {
        double[][] dp;
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct TSP with fewer than 2 vertices.");
        }
        if (n > 31) {
            throw new UnsupportedOperationException("Held-Karp cannot run with more than 31 vertices.");
        }
        int p = 1 << n;
        for (double[] row : dp = new double[p][n]) {
            Arrays.fill(row, Double.POSITIVE_INFINITY);
        }
        dp[1][0] = 0.0;
        for (int mask = 1; mask < p; ++mask) {
            for (int u = 0; u < n; ++u) {
                if ((mask & 1 << u) == 0) continue;
                for (int v = 0; v < n; ++v) {
                    if ((mask & 1 << v) != 0) continue;
                    int nextMask = mask | 1 << v;
                    dp[nextMask][v] = Math.min(dp[nextMask][v], dp[mask][u] + this.getDistance(u, v));
                }
            }
        }
        int endMask = p - 1;
        int lastNode = 0;
        double bestCost = Double.POSITIVE_INFINITY;
        for (int u = 1; u < n; ++u) {
            double cost = dp[endMask][u] + this.getDistance(u, 0);
            if (!(cost < bestCost)) continue;
            bestCost = cost;
            lastNode = u;
        }
        int mask = endMask;
        int index = 1;
        int[] tour = new int[n + 1];
        while (mask != 0) {
            tour[index++] = lastNode;
            int prevMask = mask ^ 1 << lastNode;
            for (int u = 0; u < n; ++u) {
                if (dp[mask][lastNode] != dp[prevMask][u] + this.getDistance(u, lastNode)) continue;
                lastNode = u;
                break;
            }
            mask = prevMask;
        }
        logger.info("Held-Karp TSP cost = {}", (Object)bestCost);
        MathEx.reverse(tour);
        return tour;
    }

    private int getInsertPosition(int node, int[] tour, int length) {
        int insertIndex = 1;
        double minIncrease = Double.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            int node1 = tour[i];
            int node2 = tour[(i + 1) % length];
            double increase = this.getDistance(node1, node) + this.getDistance(node, node2) - this.getDistance(node1, node2);
            if (!(increase < minIncrease)) continue;
            minIncrease = increase;
            insertIndex = i + 1;
        }
        return insertIndex;
    }

    public int[] nearestInsertion() {
        int nearestNode;
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct TSP with fewer than 2 vertices.");
        }
        int[] tour = new int[n + 1];
        double[] dist = new double[n];
        boolean[] visited = new boolean[n];
        visited[0] = true;
        Arrays.fill(dist, Double.POSITIVE_INFINITY);
        this.forEachEdge(0, (i, weight) -> {
            dist[i] = weight;
        });
        tour[1] = nearestNode = MathEx.whichMin(dist);
        visited[nearestNode] = true;
        for (int length = 2; length < n; ++length) {
            this.forEachEdge(nearestNode, (i, weight) -> {
                if (!visited[i]) {
                    dist[i] = Math.min(dist[i], weight);
                }
            });
            nearestNode = -1;
            double minDistance = Double.POSITIVE_INFINITY;
            for (int i2 = 0; i2 < n; ++i2) {
                if (visited[i2] || !(dist[i2] < minDistance)) continue;
                minDistance = dist[i2];
                nearestNode = i2;
            }
            int insertIndex = this.getInsertPosition(nearestNode, tour, length);
            System.arraycopy(tour, insertIndex, tour, insertIndex + 1, length - insertIndex);
            tour[insertIndex] = nearestNode;
            visited[nearestNode] = true;
        }
        return tour;
    }

    public int[] farthestInsertion() {
        int farthestNode;
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct TSP with fewer than 2 vertices.");
        }
        int[] tour = new int[n + 1];
        double[] dist = new double[n];
        boolean[] visited = new boolean[n];
        visited[0] = true;
        this.forEachEdge(0, (i, weight) -> {
            dist[i] = weight;
        });
        tour[1] = farthestNode = MathEx.whichMax(dist);
        visited[farthestNode] = true;
        for (int length = 2; length < n; ++length) {
            this.forEachEdge(farthestNode, (i, weight) -> {
                if (!visited[i]) {
                    dist[i] = Math.max(dist[i], weight);
                }
            });
            farthestNode = -1;
            double maxDistance = Double.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < n; ++i2) {
                if (visited[i2] || !(dist[i2] > maxDistance)) continue;
                maxDistance = dist[i2];
                farthestNode = i2;
            }
            int insertIndex = this.getInsertPosition(farthestNode, tour, length);
            System.arraycopy(tour, insertIndex, tour, insertIndex + 1, length - insertIndex);
            tour[insertIndex] = farthestNode;
            visited[farthestNode] = true;
        }
        return tour;
    }

    public int[] arbitraryInsertion() {
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct TSP with fewer than 2 vertices.");
        }
        int[] tour = new int[n + 1];
        tour[1] = 1;
        int v = 2;
        while (v < n) {
            int insertIndex = this.getInsertPosition(v, tour, v);
            System.arraycopy(tour, insertIndex, tour, insertIndex + 1, v - insertIndex);
            tour[insertIndex] = v++;
        }
        return tour;
    }

    public double opt2(int[] tour, int maxIter) {
        int n = this.getVertexCount();
        if (tour.length != n + 1) {
            throw new IllegalArgumentException("Invalid tour length: " + tour.length);
        }
        double cost = this.getPathDistance(tour);
        boolean improved = true;
        for (int iter = 0; improved && iter < maxIter; ++iter) {
            improved = false;
            for (int i = 0; i < n - 2; ++i) {
                for (int j = i + 2; j < n; ++j) {
                    double delta;
                    double d1 = this.getWeight(tour[i], tour[j]);
                    double d2 = this.getWeight(tour[i + 1], tour[(j + 1) % n]);
                    if (d1 == 0.0 || d2 == 0.0 || !((delta = d1 + d2 - this.getWeight(tour[i], tour[i + 1]) - this.getWeight(tour[j], tour[(j + 1) % n])) < 0.0)) continue;
                    this.swapEdges(tour, i, j);
                    cost += delta;
                    improved = true;
                }
            }
        }
        return cost;
    }

    public int[] christofides() {
        int n = this.getVertexCount();
        if (n < 2) {
            throw new UnsupportedOperationException("Cannot construct TSP with fewer than 2 vertices.");
        }
        ArrayList<Edge> mst = new ArrayList<Edge>();
        this.prim(mst);
        int[] degree = new int[n];
        for (Edge edge : mst) {
            int n2 = edge.u();
            degree[n2] = degree[n2] + 1;
            int n3 = edge.v();
            degree[n3] = degree[n3] + 1;
        }
        ArrayList<Integer> oddDegreeVertices = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (degree[i] % 2 == 0) continue;
            oddDegreeVertices.add(i);
        }
        int m = oddDegreeVertices.size();
        ArrayList<Edge> matching = new ArrayList<Edge>();
        boolean[] matched = new boolean[m];
        for (int i = 0; i < m; ++i) {
            if (matched[i]) continue;
            int bestPartner = -1;
            double minWeight = Double.POSITIVE_INFINITY;
            for (int j = i + 1; j < m; ++j) {
                double weight;
                if (matched[j] || !((weight = this.getDistance((Integer)oddDegreeVertices.get(i), (Integer)oddDegreeVertices.get(j))) < minWeight)) continue;
                minWeight = weight;
                bestPartner = j;
            }
            if (bestPartner == -1) continue;
            matching.add(new Edge((Integer)oddDegreeVertices.get(i), (Integer)oddDegreeVertices.get(bestPartner)));
            matched[i] = true;
            matched[bestPartner] = true;
        }
        int[][] multigraph = new int[n][matching.size() + n - 1];
        int index = 0;
        for (Edge edge : mst) {
            multigraph[edge.u()][index] = edge.v();
            multigraph[edge.v()][index++] = edge.u();
        }
        for (Edge edge : matching) {
            multigraph[edge.u()][index] = edge.v();
            multigraph[edge.v()][index++] = edge.u();
        }
        assert (index == matching.size() + n - 1);
        ArrayList<Integer> circuit = new ArrayList<Integer>();
        Stack<Integer> stack = new Stack<Integer>();
        boolean[][] visited = new boolean[n][n];
        stack.push(0);
        while (!stack.isEmpty()) {
            int u = (Integer)stack.peek();
            boolean found = false;
            for (int v : multigraph[u]) {
                if (visited[u][v]) continue;
                stack.push(v);
                visited[u][v] = true;
                visited[v][u] = true;
                found = true;
                break;
            }
            if (found) continue;
            circuit.add(u);
            stack.pop();
        }
        boolean[] inPath = new boolean[n];
        int[] tour = new int[n + 1];
        index = 0;
        Object object = circuit.iterator();
        while (object.hasNext()) {
            Integer v = (Integer)object.next();
            if (inPath[v]) continue;
            tour[index++] = v;
            inPath[v.intValue()] = true;
        }
        assert (index == n);
        return tour;
    }

    public record Edge(int u, int v, double weight) implements Comparable<Edge>
    {
        public Edge(int u, int v) {
            this(u, v, 1.0);
        }

        @Override
        public int compareTo(Edge o) {
            return Double.compare(this.weight, o.weight);
        }
    }

    private record TspNode(int[] path, double lowerBound, double cost) implements Comparable<TspNode>
    {
        public int level() {
            return this.path.length;
        }

        @Override
        public int compareTo(TspNode o) {
            return Double.compare(this.lowerBound, o.lowerBound);
        }
    }
}

