/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.io.HadoopInput;
import smile.io.LocalInputFile;

public class Parquet {
    private static final Logger logger = LoggerFactory.getLogger(Parquet.class);

    private Parquet() {
    }

    public static DataFrame read(Path path) throws IOException {
        return Parquet.read(path, Integer.MAX_VALUE);
    }

    public static DataFrame read(Path path, int limit) throws IOException {
        return Parquet.read(new LocalInputFile(path), limit);
    }

    public static DataFrame read(String path) throws IOException, URISyntaxException {
        return Parquet.read(path, Integer.MAX_VALUE);
    }

    public static DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        return Parquet.read(HadoopInput.file(path), limit);
    }

    public static DataFrame read(InputFile file) throws IOException {
        return Parquet.read(file, Integer.MAX_VALUE);
    }

    public static DataFrame read(InputFile file, int limit) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)file);){
            PageReadStore store;
            ParquetMetadata footer = reader.getFooter();
            MessageType schema = footer.getFileMetaData().getSchema();
            StructType struct = Parquet.toStructType(schema);
            logger.debug("The meta data of parquet file {}: {}", (Object)file, (Object)ParquetMetadata.toPrettyJSON((ParquetMetadata)footer));
            int size = (int)Math.min(reader.getRecordCount(), (long)limit);
            ArrayList<Tuple> rows = new ArrayList<Tuple>(size);
            while ((store = reader.readNextRowGroup()) != null) {
                long rowCount = store.getRowCount();
                MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
                RecordReader recordReader = columnIO.getRecordReader(store, (RecordMaterializer)new GroupRecordConverter(schema));
                int i = 0;
                while ((long)i < rowCount && rows.size() < size) {
                    rows.add(Tuple.of(struct, Parquet.readRowGroup((Group)recordReader.read(), schema.getColumns(), struct)));
                    ++i;
                }
            }
            DataFrame dataFrame = DataFrame.of(struct, rows);
            return dataFrame;
        }
    }

    private static Object[] readRowGroup(Group g, List<ColumnDescriptor> columns, StructType schema) {
        int length = schema.length();
        Object[] o = new Object[length];
        block26: for (int i = 0; i < length; ++i) {
            int rep = g.getFieldRepetitionCount(i);
            ColumnDescriptor column = columns.get(i);
            PrimitiveType primitiveType = column.getPrimitiveType();
            LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    if (rep == 1) {
                        o[i] = g.getBoolean(i, 0);
                        continue block26;
                    }
                    if (rep <= 1) continue block26;
                    boolean[] a = new boolean[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getBoolean(i, j);
                    }
                    o[i] = a;
                    continue block26;
                }
                case INT32: {
                    if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getInteger(i, 0);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        int[] a = new int[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getInteger(i, j);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            o[i] = BigDecimal.valueOf(g.getInteger(i, 0), scale);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = BigDecimal.valueOf(g.getInteger(i, j), scale);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = LocalDate.ofEpochDay(g.getInteger(i, 0));
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        LocalDate[] a = new LocalDate[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = LocalDate.ofEpochDay(g.getInteger(i, j));
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType;
                        if (timeType.getUnit() != LogicalTypeAnnotation.TimeUnit.MILLIS) {
                            throw new IllegalStateException("Invalid TimeUnit for INT32: " + String.valueOf(timeType.getUnit()));
                        }
                        if (rep == 1) {
                            o[i] = LocalTime.ofNanoOfDay((long)g.getInteger(i, 0) * 1000000L);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        LocalTime[] a = new LocalTime[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = LocalTime.ofNanoOfDay((long)g.getInteger(i, j) * 1000000L);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    throw new IllegalStateException("Invalid logical type for INT32: " + String.valueOf(logicalType));
                }
                case INT64: {
                    if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getLong(i, 0);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        long[] a = new long[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getLong(i, j);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            o[i] = BigDecimal.valueOf(g.getLong(i, 0), scale);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = BigDecimal.valueOf(g.getLong(i, j), scale);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType;
                        switch (timeType.getUnit()) {
                            case MILLIS: {
                                throw new IllegalStateException("Invalid TimeUnit for INT64: " + String.valueOf(timeType.getUnit()));
                            }
                            case MICROS: {
                                if (rep == 1) {
                                    o[i] = LocalTime.ofNanoOfDay(g.getLong(i, 0) * 1000L);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalTime[] a = new LocalTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    a[j] = LocalTime.ofNanoOfDay(g.getLong(i, j) * 1000L);
                                }
                                o[i] = a;
                                break;
                            }
                            case NANOS: {
                                if (rep == 1) {
                                    o[i] = LocalTime.ofNanoOfDay(g.getLong(i, 0));
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalTime[] a = new LocalTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    a[j] = LocalTime.ofNanoOfDay(g.getLong(i, j));
                                }
                                o[i] = a;
                            }
                        }
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                        ZoneId zone = timeType.isAdjustedToUTC() ? ZoneOffset.UTC : ZoneId.systemDefault();
                        switch (timeType.getUnit()) {
                            case MILLIS: {
                                if (rep == 1) {
                                    o[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(g.getLong(i, 0)), zone);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalDateTime[] a = new LocalDateTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    a[j] = LocalDateTime.ofInstant(Instant.ofEpochMilli(g.getLong(i, j)), zone);
                                }
                                o[i] = a;
                                break;
                            }
                            case MICROS: {
                                if (rep == 1) {
                                    long micros = g.getLong(i, 0);
                                    o[i] = LocalDateTime.ofInstant(Instant.ofEpochSecond(micros / 1000000L, (int)(micros % 100000L) * 1000), zone);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalDateTime[] a = new LocalDateTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    long micros = g.getLong(i, j);
                                    a[j] = LocalDateTime.ofInstant(Instant.ofEpochSecond(micros / 1000000L, (int)(micros % 100000L) * 1000), zone);
                                }
                                o[i] = a;
                                break;
                            }
                            case NANOS: {
                                if (rep == 1) {
                                    long nanos = g.getLong(i, 0);
                                    o[i] = LocalDateTime.ofInstant(Instant.ofEpochSecond(nanos / 1000000000L, (int)(nanos % 100000000L)), zone);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalDateTime[] a = new LocalDateTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    long nanos = g.getLong(i, j);
                                    a[j] = LocalDateTime.ofInstant(Instant.ofEpochSecond(nanos / 1000000000L, (int)(nanos % 100000000L)), zone);
                                }
                                o[i] = a;
                            }
                        }
                        continue block26;
                    }
                    throw new IllegalStateException("Invalid logical type for INT64: " + String.valueOf(logicalType));
                }
                case INT96: {
                    if (rep == 1) {
                        ByteBuffer buf = g.getInt96(i, 0).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                        long nanoOfDay = buf.getLong();
                        int julianDay = buf.getInt();
                        LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                        LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                        o[i] = LocalDateTime.of(date, time);
                        continue block26;
                    }
                    if (rep <= 1) continue block26;
                    LocalDateTime[] a = new LocalDateTime[rep];
                    for (int j = 0; j < rep; ++j) {
                        ByteBuffer buf = g.getInt96(i, 0).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                        long nanoOfDay = buf.getLong();
                        int julianDay = buf.getInt();
                        LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                        LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                        a[j] = LocalDateTime.of(date, time);
                    }
                    o[i] = a;
                    continue block26;
                }
                case FLOAT: {
                    if (rep == 1) {
                        o[i] = Float.valueOf(g.getFloat(i, 0));
                        continue block26;
                    }
                    if (rep <= 1) continue block26;
                    float[] a = new float[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getFloat(i, j);
                    }
                    o[i] = a;
                    continue block26;
                }
                case DOUBLE: {
                    if (rep == 1) {
                        o[i] = g.getDouble(i, 0);
                        continue block26;
                    }
                    if (rep <= 1) continue block26;
                    double[] a = new double[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getDouble(i, j);
                    }
                    o[i] = a;
                    continue block26;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    LogicalTypeAnnotation a = logicalType;
                    int j = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalTypeAnnotation.UUIDLogicalTypeAnnotation.class, LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.class, LogicalTypeAnnotation.DecimalLogicalTypeAnnotation.class, LogicalTypeAnnotation.StringLogicalTypeAnnotation.class}, (Object)a, j)) {
                        case 0: {
                            LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidType = (LogicalTypeAnnotation.UUIDLogicalTypeAnnotation)a;
                            if (rep == 1) {
                                byte[] bytes = g.getBinary(i, 0).getBytes();
                                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                                long high = byteBuffer.getLong();
                                long low = byteBuffer.getLong();
                                o[i] = new UUID(high, low);
                                break;
                            }
                            if (rep <= 1) continue block26;
                            UUID[] a2 = new UUID[rep];
                            for (int j2 = 0; j2 < rep; ++j2) {
                                byte[] bytes = g.getBinary(i, j2).getBytes();
                                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                                long high = byteBuffer.getLong();
                                long low = byteBuffer.getLong();
                                a2[j2] = new UUID(high, low);
                            }
                            o[i] = a2;
                            break;
                        }
                        case 1: {
                            LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervaType = (LogicalTypeAnnotation.IntervalLogicalTypeAnnotation)a;
                            if (rep == 1) {
                                byte[] bytes = g.getBinary(i, 0).getBytes();
                                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                                int months = byteBuffer.getInt();
                                int days = byteBuffer.getInt();
                                int millis = byteBuffer.getInt();
                                Duration duration = Duration.ofDays(days);
                                o[i] = duration.plusDays((long)months * 30L).plusMillis(millis);
                                break;
                            }
                            if (rep <= 1) continue block26;
                            Duration[] a3 = new Duration[rep];
                            for (int j3 = 0; j3 < rep; ++j3) {
                                byte[] bytes = g.getBinary(i, j3).getBytes();
                                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                                int months = byteBuffer.getInt();
                                int days = byteBuffer.getInt();
                                int millis = byteBuffer.getInt();
                                Duration duration = Duration.ofDays(days);
                                a3[j3] = duration.plusDays((long)months * 30L).plusMillis(millis);
                            }
                            o[i] = a3;
                            break;
                        }
                        case 2: {
                            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)a;
                            int scale = decimalType.getScale();
                            if (rep == 1) {
                                byte[] value = g.getBinary(i, 0).getBytes();
                                o[i] = new BigDecimal(new BigInteger(value), scale);
                                break;
                            }
                            if (rep <= 1) continue block26;
                            BigDecimal[] a4 = new BigDecimal[rep];
                            for (int j4 = 0; j4 < rep; ++j4) {
                                byte[] value = g.getBinary(i, j4).getBytes();
                                a4[j4] = new BigDecimal(new BigInteger(value), scale);
                            }
                            o[i] = a4;
                            break;
                        }
                        case 3: {
                            LogicalTypeAnnotation.StringLogicalTypeAnnotation stringType = (LogicalTypeAnnotation.StringLogicalTypeAnnotation)a;
                            if (rep == 1) {
                                o[i] = g.getString(i, 0);
                                break;
                            }
                            if (rep <= 1) continue block26;
                            String[] a5 = new String[rep];
                            for (int j5 = 0; j5 < rep; ++j5) {
                                a5[j5] = g.getString(i, j5);
                            }
                            o[i] = a5;
                            break;
                        }
                        default: {
                            if (rep == 1) {
                                o[i] = g.getBinary(i, 0).getBytes();
                                break;
                            }
                            if (rep <= 1) continue block26;
                            byte[][] a6 = new byte[rep][];
                            for (int j6 = 0; j6 < rep; ++j6) {
                                a6[j6] = g.getBinary(i, j6).getBytes();
                            }
                            o[i] = a6;
                            break;
                        }
                    }
                    continue block26;
                }
                case BINARY: {
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            byte[] value = g.getBinary(i, 0).getBytes();
                            o[i] = new BigDecimal(new BigInteger(value), scale);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            byte[] value = g.getBinary(i, j).getBytes();
                            a[j] = new BigDecimal(new BigInteger(value), scale);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation || logicalType instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getString(i, 0);
                            continue block26;
                        }
                        if (rep <= 1) continue block26;
                        String[] a = new String[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getString(i, j);
                        }
                        o[i] = a;
                        continue block26;
                    }
                    if (rep == 1) {
                        o[i] = g.getBinary(i, 0).getBytes();
                        continue block26;
                    }
                    if (rep <= 1) continue block26;
                    byte[][] a = new byte[rep][];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getBinary(i, j).getBytes();
                    }
                    o[i] = a;
                }
            }
        }
        return o;
    }

    public static DataType toDataType(PrimitiveType primitiveType) {
        PrimitiveType.PrimitiveTypeName typeName = primitiveType.getPrimitiveTypeName();
        LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
        Type.Repetition repetition = primitiveType.getRepetition();
        return switch (typeName) {
            default -> throw new MatchException(null, null);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> {
                switch (repetition) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case REQUIRED: {
                        yield DataTypes.BooleanType;
                    }
                    case OPTIONAL: {
                        yield DataTypes.NullableBooleanType;
                    }
                    case REPEATED: 
                }
                yield DataTypes.BooleanArrayType;
            }
            case PrimitiveType.PrimitiveTypeName.INT32 -> {
                LogicalTypeAnnotation var4_4 = logicalType;
                int var5_8 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalTypeAnnotation.DecimalLogicalTypeAnnotation.class, LogicalTypeAnnotation.DateLogicalTypeAnnotation.class, LogicalTypeAnnotation.TimeLogicalTypeAnnotation.class}, (Object)var4_4, var5_8)) {
                    case 0: {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)var4_4;
                        yield DataTypes.DecimalType;
                    }
                    case 1: {
                        LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalTypeAnnotation = (LogicalTypeAnnotation.DateLogicalTypeAnnotation)var4_4;
                        yield DataTypes.DateType;
                    }
                    case 2: {
                        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalTypeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)var4_4;
                        yield DataTypes.TimeType;
                    }
                }
                switch (repetition) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case REQUIRED: {
                        yield DataTypes.IntType;
                    }
                    case OPTIONAL: {
                        yield DataTypes.NullableIntType;
                    }
                    case REPEATED: 
                }
                yield DataTypes.IntArrayType;
            }
            case PrimitiveType.PrimitiveTypeName.INT64 -> {
                LogicalTypeAnnotation var4_5 = logicalType;
                int var5_9 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalTypeAnnotation.DecimalLogicalTypeAnnotation.class, LogicalTypeAnnotation.TimeLogicalTypeAnnotation.class, LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.class}, (Object)var4_5, var5_9)) {
                    case 0: {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)var4_5;
                        yield DataTypes.DecimalType;
                    }
                    case 1: {
                        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalTypeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)var4_5;
                        yield DataTypes.TimeType;
                    }
                    case 2: {
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var4_5;
                        yield DataTypes.DateTimeType;
                    }
                }
                switch (repetition) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case REQUIRED: {
                        yield DataTypes.LongType;
                    }
                    case OPTIONAL: {
                        yield DataTypes.NullableLongType;
                    }
                    case REPEATED: 
                }
                yield DataTypes.LongArrayType;
            }
            case PrimitiveType.PrimitiveTypeName.INT96 -> DataTypes.DateTimeType;
            case PrimitiveType.PrimitiveTypeName.FLOAT -> {
                switch (repetition) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case REQUIRED: {
                        yield DataTypes.FloatType;
                    }
                    case OPTIONAL: {
                        yield DataTypes.NullableFloatType;
                    }
                    case REPEATED: 
                }
                yield DataTypes.FloatArrayType;
            }
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> {
                switch (repetition) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case REQUIRED: {
                        yield DataTypes.DoubleType;
                    }
                    case OPTIONAL: {
                        yield DataTypes.NullableDoubleType;
                    }
                    case REPEATED: 
                }
                yield DataTypes.DoubleArrayType;
            }
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> {
                LogicalTypeAnnotation v1 = logicalType;
                Objects.requireNonNull(v1);
                LogicalTypeAnnotation var4_6 = v1;
                int var5_10 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalTypeAnnotation.UUIDLogicalTypeAnnotation.class, LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.class, LogicalTypeAnnotation.DecimalLogicalTypeAnnotation.class, LogicalTypeAnnotation.StringLogicalTypeAnnotation.class}, (Object)var4_6, var5_10)) {
                    case 0: {
                        LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalTypeAnnotation = (LogicalTypeAnnotation.UUIDLogicalTypeAnnotation)var4_6;
                        yield DataTypes.ObjectType;
                    }
                    case 1: {
                        LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalTypeAnnotation = (LogicalTypeAnnotation.IntervalLogicalTypeAnnotation)var4_6;
                        yield DataTypes.ObjectType;
                    }
                    case 2: {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)var4_6;
                        yield DataTypes.DecimalType;
                    }
                    case 3: {
                        LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalTypeAnnotation = (LogicalTypeAnnotation.StringLogicalTypeAnnotation)var4_6;
                        yield DataTypes.StringType;
                    }
                }
                yield DataTypes.ByteArrayType;
            }
            case PrimitiveType.PrimitiveTypeName.BINARY -> {
                LogicalTypeAnnotation v2 = logicalType;
                Objects.requireNonNull(v2);
                LogicalTypeAnnotation var4_7 = v2;
                int var5_11 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalTypeAnnotation.DecimalLogicalTypeAnnotation.class, LogicalTypeAnnotation.StringLogicalTypeAnnotation.class}, (Object)var4_7, var5_11)) {
                    case 0: {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)var4_7;
                        yield DataTypes.DecimalType;
                    }
                    case 1: {
                        LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalTypeAnnotation = (LogicalTypeAnnotation.StringLogicalTypeAnnotation)var4_7;
                        yield DataTypes.StringType;
                    }
                }
                yield DataTypes.ByteArrayType;
            }
        };
    }

    public static StructField toStructField(ColumnDescriptor column) {
        String name = String.join((CharSequence)".", column.getPath());
        DataType dtype = Parquet.toDataType(column.getPrimitiveType());
        return new StructField(name, dtype);
    }

    public static StructType toStructType(MessageType schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (ColumnDescriptor column : schema.getColumns()) {
            fields.add(Parquet.toStructField(column));
        }
        return new StructType(fields);
    }
}

