/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.HyperbolicTangent;
import smile.math.kernel.MercerKernel;
import smile.util.SparseArray;

public class SparseHyperbolicTangentKernel
extends HyperbolicTangent
implements MercerKernel<SparseArray> {
    public SparseHyperbolicTangentKernel() {
        this(1.0, 0.0);
    }

    public SparseHyperbolicTangentKernel(double scale, double offset) {
        this(scale, offset, new double[]{0.01, 1.0E-5}, new double[]{100.0, 100000.0});
    }

    public SparseHyperbolicTangentKernel(double scale, double offset, double[] lo, double[] hi) {
        super(scale, offset, lo, hi);
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        return this.k(MathEx.dot(x, y));
    }

    @Override
    public double[] kg(SparseArray x, SparseArray y) {
        return this.kg(MathEx.dot(x, y));
    }

    public SparseHyperbolicTangentKernel of(double[] params) {
        return new SparseHyperbolicTangentKernel(params[0], params[1], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.scale, this.offset};
    }

    @Override
    public double[] lo() {
        return this.lo;
    }

    @Override
    public double[] hi() {
        return this.hi;
    }
}

