/*
 * Decompiled with CFR 0.152.
 */
package smile.taxonomy;

import java.util.Iterator;
import java.util.List;
import smile.math.distance.Distance;
import smile.taxonomy.Concept;
import smile.taxonomy.Taxonomy;

public class TaxonomicDistance
implements Distance<Concept> {
    private final Taxonomy taxonomy;

    public TaxonomicDistance(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    public String toString() {
        return String.format("Taxonomic distance on %s", this.taxonomy);
    }

    @Override
    public double d(String x, String y) {
        return this.d(this.taxonomy.getConcept(x), this.taxonomy.getConcept(y));
    }

    @Override
    public double d(Concept x, Concept y) {
        if (x.taxonomy != y.taxonomy) {
            throw new IllegalArgumentException("Concepts are not from the same taxonomy.");
        }
        List<Concept> xPath = x.getPathFromRoot();
        List<Concept> yPath = y.getPathFromRoot();
        Iterator<Concept> xIter = xPath.iterator();
        Iterator<Concept> yIter = yPath.iterator();
        int depth = 0;
        while (xIter.hasNext() && yIter.hasNext() && xIter.next() == yIter.next()) {
            ++depth;
        }
        return xPath.size() - depth + yPath.size() - depth;
    }
}

