/*
 * Decompiled with CFR 0.152.
 */
package smile.util.function;

import smile.util.function.MultivariateFunction;

public interface DifferentiableMultivariateFunction
extends MultivariateFunction {
    public static final double EPSILON = Double.parseDouble(System.getProperty("smile.gradient.epsilon", "1E-8"));

    default public double g(double[] x, double[] gradient) {
        double fx = this.f(x);
        int n = x.length;
        double[] xh = new double[n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(x, 0, xh, 0, n);
            double xi = x[i];
            double h = EPSILON * Math.abs(xi);
            if (h == 0.0) {
                h = EPSILON;
            }
            xh[i] = xi + h;
            h = xh[i] - xi;
            double fh = this.f(xh);
            xh[i] = xi;
            gradient[i] = (fh - fx) / h;
        }
        return fx;
    }
}

