/*
 * Decompiled with CFR 0.152.
 */
package smile.util.function;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;

public interface Function
extends Serializable {
    public static final Logger logger = LoggerFactory.getLogger(Function.class);

    public double f(double var1);

    default public double inv(double x) {
        throw new UnsupportedOperationException();
    }

    default public double apply(double x) {
        return this.f(x);
    }

    default public double root(double x1, double x2, double tol, int maxIter) {
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        double a = x1;
        double b = x2;
        double c = x2;
        double d = 0.0;
        double e = 0.0;
        double fa = this.f(a);
        double fb = this.f(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed.");
        }
        double fc = fb;
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            tol = 2.0 * MathEx.EPSILON * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (iter % 10 == 0) {
                logger.info("Brent: the root after {} iterations: {}, error = {}", new Object[]{iter, b, xm});
            }
            if (Math.abs(xm) <= tol || fb == 0.0) {
                logger.info("Brent finds the root after {} iterations: {}, error = {}", new Object[]{iter, b, xm});
                return b;
            }
            if (Math.abs(e) >= tol && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double min1;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) < Math.min(min1 = 3.0 * xm * q - Math.abs(tol * q), min2 = Math.abs(e * q))) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol ? (b += d) : (b += Math.copySign(tol, xm));
            fb = this.f(b);
        }
        logger.error("Brent exceeded the maximum number of iterations.");
        return b;
    }
}

