/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.data.SampleInstance;
import smile.data.SimpleDataset;
import smile.math.MathEx;

public interface Dataset<D, T>
extends Iterable<SampleInstance<D, T>> {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public SampleInstance<D, T> get(int var1);

    default public SampleInstance<D, T> apply(int i) {
        return this.get(i);
    }

    public Stream<SampleInstance<D, T>> stream();

    default public Iterator<List<SampleInstance<D, T>>> batch(final int size) {
        return new Iterator<List<SampleInstance<D, T>>>(){
            final int[] permutation;
            int i;
            {
                this.permutation = MathEx.permutate(Dataset.this.size());
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < Dataset.this.size();
            }

            @Override
            public List<SampleInstance<D, T>> next() {
                int length = Math.min(size, Dataset.this.size() - this.i);
                ArrayList batch = new ArrayList(length);
                int j = 0;
                while (j < length) {
                    batch.add(Dataset.this.get(this.permutation[this.i]));
                    ++j;
                    ++this.i;
                }
                return batch;
            }
        };
    }

    default public List<SampleInstance<D, T>> toList() {
        return this.stream().toList();
    }

    default public String toString(int numRows) {
        StringBuilder sb = new StringBuilder();
        String top = this.stream().limit(numRows).map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
        sb.append(top);
        int rest = this.size() - numRows;
        if (rest > 0) {
            String rowsString = rest == 1 ? "row" : "rows";
            sb.append(String.format("%n%d more %s...%n", rest, rowsString));
        }
        return sb.toString();
    }

    public static <D, T> Dataset<D, T> of(Collection<SampleInstance<D, T>> instances) {
        return new SimpleDataset<D, T>(instances);
    }

    public static <D, T> Dataset<D, T> of(List<D> data, List<T> target) {
        ArrayList instances = new ArrayList();
        for (int i = 0; i < data.size(); ++i) {
            instances.add(new SampleInstance<D, T>(data.get(i), target.get(i)));
        }
        return new SimpleDataset(instances);
    }

    public static <D, T> Dataset<D, T> of(D[] data, T[] target) {
        ArrayList instances = new ArrayList();
        for (int i = 0; i < data.length; ++i) {
            instances.add(new SampleInstance<D, T>(data[i], target[i]));
        }
        return new SimpleDataset(instances);
    }

    public static <D> Dataset<D, Integer> of(D[] data, int[] target) {
        ArrayList instances = new ArrayList();
        for (int i = 0; i < data.length; ++i) {
            instances.add(new SampleInstance<D, Integer>(data[i], target[i]));
        }
        return new SimpleDataset(instances);
    }

    public static <D> Dataset<D, Float> of(D[] data, float[] target) {
        ArrayList instances = new ArrayList();
        for (int i = 0; i < data.length; ++i) {
            instances.add(new SampleInstance<D, Float>(data[i], Float.valueOf(target[i])));
        }
        return new SimpleDataset(instances);
    }

    public static <D> Dataset<D, Double> of(D[] data, double[] target) {
        ArrayList instances = new ArrayList();
        for (int i = 0; i < data.length; ++i) {
            instances.add(new SampleInstance<D, Double>(data[i], target[i]));
        }
        return new SimpleDataset(instances);
    }
}

