/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.Tuple;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.NominalScale;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class FactorInteraction
implements Term {
    private final List<String> factors;

    public FactorInteraction(String ... factors) {
        if (factors.length < 2) {
            throw new IllegalArgumentException("Interaction() takes at least two factors");
        }
        this.factors = Arrays.asList(factors);
    }

    public int size() {
        return this.factors.size();
    }

    public String toString() {
        return String.join((CharSequence)":", this.factors);
    }

    @Override
    public Set<String> variables() {
        return new HashSet<String>(this.factors);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        List<StructField> fields = this.factors.stream().map(schema::field).toList();
        for (StructField field : fields) {
            if (field.measure() instanceof CategoricalMeasure) continue;
            throw new IllegalStateException(String.format("%s is not a categorical variable: %s", field.name(), field.measure()));
        }
        List<String> levels = new ArrayList<String>();
        levels.add("");
        for (StructField field : fields) {
            CategoricalMeasure cat = (CategoricalMeasure)field.measure();
            levels = levels.stream().flatMap(l -> Arrays.stream(cat.levels()).map(level -> l.isEmpty() ? level : l + ":" + level)).toList();
        }
        return Collections.singletonList(new InteractionFeature(levels));
    }

    private class InteractionFeature
    implements Feature {
        final NominalScale measure;
        final StructField field;

        InteractionFeature(List<String> levels) {
            this.measure = new NominalScale(levels);
            this.field = new StructField(String.join((CharSequence)":", FactorInteraction.this.factors), DataTypes.IntType, this.measure);
        }

        public String toString() {
            return this.field.name();
        }

        @Override
        public StructField field() {
            return this.field;
        }

        @Override
        public int applyAsInt(Tuple o) {
            String level = FactorInteraction.this.factors.stream().map(o::getString).collect(Collectors.joining(":"));
            return this.measure.valueOf(level).intValue();
        }

        @Override
        public Object apply(Tuple o) {
            String level = FactorInteraction.this.factors.stream().map(o::getString).collect(Collectors.joining(":"));
            return this.measure.valueOf(level);
        }
    }
}

