/*
 * Decompiled with CFR 0.152.
 */
package smile.data.transform;

import java.util.BitSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.Measure;
import smile.data.measure.NumericalMeasure;
import smile.data.transform.Transform;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.DoubleVector;
import smile.data.vector.NullableDoubleVector;
import smile.data.vector.ValueVector;
import smile.util.function.Function;

public class ColumnTransform
implements Transform {
    private final String name;
    private final Map<String, Function> transforms;

    public ColumnTransform(String name, Map<String, Function> transforms) {
        this.name = name;
        this.transforms = transforms;
    }

    @Override
    public Tuple apply(final Tuple x) {
        return new AbstractTuple(x.schema()){

            @Override
            public Object get(int i) {
                Function transform = ColumnTransform.this.transforms.get(this.schema.field(i).name());
                if (transform != null) {
                    return transform.apply(x.getDouble(i));
                }
                return x.get(i);
            }
        };
    }

    @Override
    public DataFrame apply(DataFrame data) {
        StructType schema = data.schema();
        ValueVector[] vectors = new ValueVector[schema.length()];
        IntStream.range(0, schema.length()).parallel().forEach(i -> {
            StructField field = schema.field(i);
            ValueVector column = data.column(i);
            Function transform = this.transforms.get(field.name());
            if (transform != null) {
                Measure measure;
                DoubleStream stream = column.doubleStream().map(transform::apply);
                Measure measure2 = measure = field.measure() instanceof NumericalMeasure ? field.measure() : null;
                if (column.isNullable()) {
                    int n = column.size();
                    BitSet mask = new BitSet(n);
                    for (int j = 0; j < n; ++j) {
                        mask.set(j, column.isNullAt(j));
                    }
                    StructField prop = new StructField(field.name(), DataTypes.NullableDoubleType, measure);
                    vectors[i] = new NullableDoubleVector(prop, stream.toArray(), mask);
                } else {
                    StructField prop = new StructField(field.name(), DataTypes.DoubleType, measure);
                    vectors[i] = new DoubleVector(prop, stream.toArray());
                }
            } else {
                vectors[i] = column;
            }
        });
        return new DataFrame(vectors);
    }

    public String toString() {
        return this.transforms.values().stream().map(Object::toString).collect(Collectors.joining(",\n  ", this.name + "(\n  ", "\n)"));
    }
}

