/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.IntStream;
import smile.data.measure.NumericalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.util.Index;

public class BooleanVector
extends PrimitiveVector {
    private final BitSet vector;
    private final int size;

    public BooleanVector(String name, boolean[] vector) {
        this(new StructField(name, DataTypes.BooleanType), vector);
    }

    public BooleanVector(StructField field, boolean[] vector) {
        this(field, vector.length, BooleanVector.bitSet(vector));
    }

    public BooleanVector(String name, int size, BitSet bits) {
        this(new StructField(name, DataTypes.BooleanType), size, bits);
    }

    public BooleanVector(StructField field, int size, BitSet bits) {
        super(field);
        if (field.dtype() != DataTypes.BooleanType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof NumericalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        this.size = size;
        this.vector = bits;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BooleanVector withName(String name) {
        return new BooleanVector(this.field.withName(name), this.size, this.vector);
    }

    @Override
    public IntStream intStream() {
        return this.index().map(i -> this.vector.get(i) ? 1 : 0);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Boolean bool = (Boolean)value;
        this.vector.set(i, bool);
    }

    @Override
    public BooleanVector get(Index index) {
        int n = index.size();
        BitSet data = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            data.set(i, this.vector.get(index.apply(i)));
        }
        return new BooleanVector(this.field, n, data);
    }

    @Override
    public Boolean get(int i) {
        return this.vector.get(i);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector.get(i);
    }

    @Override
    public char getChar(int i) {
        return this.vector.get(i) ? (char)'T' : 'F';
    }

    @Override
    public byte getByte(int i) {
        return this.vector.get(i) ? (byte)1 : 0;
    }

    @Override
    public short getShort(int i) {
        return this.vector.get(i) ? (short)1 : 0;
    }

    @Override
    public int getInt(int i) {
        return this.vector.get(i) ? 1 : 0;
    }

    @Override
    public long getLong(int i) {
        return this.vector.get(i) ? 1L : 0L;
    }

    @Override
    public float getFloat(int i) {
        return this.vector.get(i) ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble(int i) {
        return this.vector.get(i) ? 1.0 : 0.0;
    }
}

