/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.AbstractVector;
import smile.util.Index;

public class ObjectVector<T>
extends AbstractVector {
    final T[] vector;

    public ObjectVector(String name, T[] vector) {
        this(new StructField(name, DataTypes.object(vector.getClass().getComponentType())), vector);
    }

    public ObjectVector(StructField field, T[] vector) {
        super(field);
        this.vector = vector;
    }

    public static ObjectVector<boolean[]> of(String name, boolean[] ... vector) {
        return new ObjectVector<boolean[]>(new StructField(name, DataTypes.BooleanType), (T[])vector);
    }

    public static ObjectVector<char[]> of(String name, char[] ... vector) {
        return new ObjectVector<char[]>(new StructField(name, DataTypes.CharArrayType), (T[])vector);
    }

    public static ObjectVector<byte[]> of(String name, byte[] ... vector) {
        return new ObjectVector<byte[]>(new StructField(name, DataTypes.ByteArrayType), (T[])vector);
    }

    public static ObjectVector<short[]> of(String name, short[] ... vector) {
        return new ObjectVector<short[]>(new StructField(name, DataTypes.ShortArrayType), (T[])vector);
    }

    public static ObjectVector<int[]> of(String name, int[] ... vector) {
        return new ObjectVector<int[]>(new StructField(name, DataTypes.IntArrayType), (T[])vector);
    }

    public static ObjectVector<long[]> of(String name, long[] ... vector) {
        return new ObjectVector<long[]>(new StructField(name, DataTypes.LongArrayType), (T[])vector);
    }

    public static ObjectVector<float[]> of(String name, float[] ... vector) {
        return new ObjectVector<float[]>(new StructField(name, DataTypes.FloatArrayType), (T[])vector);
    }

    public static ObjectVector<double[]> of(String name, double[] ... vector) {
        return new ObjectVector<double[]>(new StructField(name, DataTypes.DoubleArrayType), (T[])vector);
    }

    @Override
    public ObjectVector<T> withName(String name) {
        return new ObjectVector<T>(this.field.withName(name), this.vector);
    }

    public Stream<T> stream() {
        return Arrays.stream(this.vector);
    }

    public List<T> distinct() {
        return this.stream().distinct().toList();
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public void set(int i, Object value) {
        this.vector[i] = value;
    }

    @Override
    public ObjectVector<T> get(Index index) {
        T[] data = Arrays.copyOf(this.vector, index.size());
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.vector[index.apply(i)];
        }
        return new ObjectVector<T>(this.field, data);
    }

    public T get(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return (Boolean)this.vector[i];
    }

    @Override
    public char getChar(int i) {
        return ((Character)this.vector[i]).charValue();
    }

    @Override
    public byte getByte(int i) {
        return ((Number)this.vector[i]).byteValue();
    }

    @Override
    public short getShort(int i) {
        return ((Number)this.vector[i]).shortValue();
    }

    @Override
    public int getInt(int i) {
        return ((Number)this.vector[i]).intValue();
    }

    @Override
    public long getLong(int i) {
        return ((Number)this.vector[i]).longValue();
    }

    @Override
    public float getFloat(int i) {
        T t2 = this.vector[i];
        if (t2 instanceof Number) {
            Number n = (Number)t2;
            return n.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public double getDouble(int i) {
        T t2 = this.vector[i];
        if (t2 instanceof Number) {
            Number n = (Number)t2;
            return n.doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isNullAt(int i) {
        return this.get(i) == null;
    }

    @Override
    public int getNullCount() {
        return (int)this.stream().filter(Objects::nonNull).count();
    }
}

