/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.type.ArrayType;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.ObjectType;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.LongVector;
import smile.data.vector.NullableBooleanVector;
import smile.data.vector.NullableByteVector;
import smile.data.vector.NullableCharVector;
import smile.data.vector.NullableDoubleVector;
import smile.data.vector.NullableFloatVector;
import smile.data.vector.NullableIntVector;
import smile.data.vector.NullableLongVector;
import smile.data.vector.NullableShortVector;
import smile.data.vector.NumberVector;
import smile.data.vector.ObjectVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.ValueVector;
import smile.io.Input;

public class Arrow {
    private static final Logger logger = LoggerFactory.getLogger(Arrow.class);
    private static RootAllocator allocator;
    private final int batch;

    public Arrow() {
        this(1000000);
    }

    public Arrow(int batch) {
        if (batch <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + batch);
        }
        this.batch = batch;
    }

    public static void allocate(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid RootAllocator limit: " + limit);
        }
        allocator = new RootAllocator(limit);
    }

    public DataFrame read(Path path) throws IOException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(Path path, int limit) throws IOException {
        return this.read(Files.newInputStream(path, new OpenOption[0]), limit);
    }

    public DataFrame read(String path) throws IOException, URISyntaxException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        return this.read(Input.stream(path), limit);
    }

    public DataFrame read(InputStream input, int limit) throws IOException {
        if (allocator == null) {
            Arrow.allocate(Long.MAX_VALUE);
        }
        try (ArrowStreamReader reader = new ArrowStreamReader(input, (BufferAllocator)allocator);){
            Iterable fieldVectors;
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            ArrayList<DataFrame> frames = new ArrayList<DataFrame>();
            for (int size = 0; reader.loadNextBatch() && size < limit; size += frames.size()) {
                fieldVectors = root.getFieldVectors();
                logger.info("read {} rows and {} columns", (Object)root.getRowCount(), (Object)fieldVectors.size());
                ValueVector[] vectors = new ValueVector[fieldVectors.size()];
                block29: for (int j = 0; j < fieldVectors.size(); ++j) {
                    FieldVector fieldVector = (FieldVector)fieldVectors.get(j);
                    ArrowType type = fieldVector.getField().getType();
                    switch (type.getTypeID()) {
                        case Int: {
                            ArrowType.Int itype = (ArrowType.Int)type;
                            int bitWidth = itype.getBitWidth();
                            switch (bitWidth) {
                                case 8: {
                                    vectors[j] = this.readByteField(fieldVector);
                                    continue block29;
                                }
                                case 16: {
                                    if (itype.getIsSigned()) {
                                        vectors[j] = this.readShortField(fieldVector);
                                        continue block29;
                                    }
                                    vectors[j] = this.readCharField(fieldVector);
                                    continue block29;
                                }
                                case 32: {
                                    vectors[j] = this.readIntField(fieldVector);
                                    continue block29;
                                }
                                case 64: {
                                    vectors[j] = this.readLongField(fieldVector);
                                    continue block29;
                                }
                            }
                            throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
                        }
                        case FloatingPoint: {
                            FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                            switch (precision) {
                                case DOUBLE: {
                                    vectors[j] = this.readDoubleField(fieldVector);
                                    continue block29;
                                }
                                case SINGLE: {
                                    vectors[j] = this.readFloatField(fieldVector);
                                    continue block29;
                                }
                                case HALF: {
                                    throw new UnsupportedOperationException("Unsupported float precision: " + String.valueOf(precision));
                                }
                            }
                            continue block29;
                        }
                        case Decimal: {
                            vectors[j] = this.readDecimalField(fieldVector);
                            continue block29;
                        }
                        case Bool: {
                            vectors[j] = this.readBitField(fieldVector);
                            continue block29;
                        }
                        case Date: {
                            vectors[j] = this.readDateField(fieldVector);
                            continue block29;
                        }
                        case Time: {
                            vectors[j] = this.readTimeField(fieldVector);
                            continue block29;
                        }
                        case Timestamp: {
                            vectors[j] = this.readDateTimeField(fieldVector);
                            continue block29;
                        }
                        case Binary: 
                        case FixedSizeBinary: {
                            vectors[j] = this.readByteArrayField(fieldVector);
                            continue block29;
                        }
                        case Utf8: {
                            vectors[j] = this.readStringField(fieldVector);
                            continue block29;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported column type: " + String.valueOf(fieldVector.getMinorType()));
                        }
                    }
                }
                DataFrame frame = new DataFrame(vectors);
                frames.add(frame);
            }
            if (frames.isEmpty()) {
                throw new IllegalStateException("No record batch");
            }
            if (frames.size() == 1) {
                fieldVectors = (DataFrame)frames.getFirst();
                return fieldVectors;
            }
            DataFrame df = (DataFrame)frames.getFirst();
            DataFrame dataFrame = df.concat(frames.subList(1, frames.size()).toArray(new DataFrame[frames.size() - 1]));
            return dataFrame;
        }
    }

    public void write(DataFrame data, Path path) throws IOException {
        if (allocator == null) {
            Arrow.allocate(Long.MAX_VALUE);
        }
        Schema schema = Arrow.toArrow(data.schema());
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             OutputStream output = Files.newOutputStream(path, new OpenOption[0]);
             ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)provider, output);){
            writer.start();
            int size = data.size();
            for (int from = 0; from < size; from += this.batch) {
                int count = Math.min(this.batch, size - from);
                root.setRowCount(count);
                block32: for (Field field : root.getSchema().getFields()) {
                    FieldVector vector = root.getVector(field.getName());
                    DataType type = data.schema().field(field.getName()).dtype();
                    switch (type.id()) {
                        case Int: {
                            this.writeIntField(data, vector, from, count);
                            continue block32;
                        }
                        case Long: {
                            this.writeLongField(data, vector, from, count);
                            continue block32;
                        }
                        case Double: {
                            this.writeDoubleField(data, vector, from, count);
                            continue block32;
                        }
                        case Float: {
                            this.writeFloatField(data, vector, from, count);
                            continue block32;
                        }
                        case Boolean: {
                            this.writeBooleanField(data, vector, from, count);
                            continue block32;
                        }
                        case Byte: {
                            this.writeByteField(data, vector, from, count);
                            continue block32;
                        }
                        case Short: {
                            this.writeShortField(data, vector, from, count);
                            continue block32;
                        }
                        case Char: {
                            this.writeCharField(data, vector, from, count);
                            continue block32;
                        }
                        case String: {
                            this.writeStringField(data, vector, from, count);
                            continue block32;
                        }
                        case Date: {
                            this.writeDateField(data, vector, from, count);
                            continue block32;
                        }
                        case Time: {
                            this.writeTimeField(data, vector, from, count);
                            continue block32;
                        }
                        case DateTime: {
                            this.writeDateTimeField(data, vector, from, count);
                            continue block32;
                        }
                        case Object: {
                            Class<?> clazz = ((ObjectType)type).getObjectClass();
                            if (clazz == Integer.class) {
                                this.writeNullableIntField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Long.class) {
                                this.writeNullableLongField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Double.class) {
                                this.writeNullableDoubleField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Float.class) {
                                this.writeNullableFloatField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Boolean.class) {
                                this.writeNullableBooleanField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Byte.class) {
                                this.writeNullableByteField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Short.class) {
                                this.writeNullableShortField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Character.class) {
                                this.writeNullableCharField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == BigDecimal.class) {
                                this.writeDecimalField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == String.class) {
                                this.writeStringField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == LocalDate.class) {
                                this.writeDateField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == LocalTime.class) {
                                this.writeTimeField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == LocalDateTime.class) {
                                this.writeDateTimeField(data, vector, from, count);
                                continue block32;
                            }
                            throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
                        }
                        case Array: {
                            DataType etype = ((ArrayType)type).getComponentType();
                            if (etype.id() == DataType.ID.Byte) {
                                this.writeByteArrayField(data, vector, from, count);
                                continue block32;
                            }
                            throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
                }
                writer.writeBatch();
                logger.info("write {} rows", (Object)count);
            }
        }
    }

    private ValueVector readBitField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        BitVector vector = (BitVector)fieldVector;
        BitSet data = new BitSet(count);
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data.set(i, vector.get(i) != 0);
            }
            return new BooleanVector(name, count, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data.set(i, vector.get(i) != 0);
        }
        return new NullableBooleanVector(name, count, data, mask);
    }

    private ValueVector readByteField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        byte[] data = new byte[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = vector.get(i);
            }
            return new ByteVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = vector.get(i);
        }
        return new NullableByteVector(name, data, mask);
    }

    private ValueVector readCharField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        char[] data = new char[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = (char)vector.get(i);
            }
            return new CharVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = (char)vector.get(i);
        }
        return new NullableCharVector(name, data, mask);
    }

    private ValueVector readShortField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        short[] data = new short[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = vector.get(i);
            }
            return new ShortVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = vector.get(i);
        }
        return new NullableShortVector(name, data, mask);
    }

    private ValueVector readIntField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        IntVector vector = (IntVector)fieldVector;
        int[] data = new int[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = vector.get(i);
            }
            return new smile.data.vector.IntVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = vector.get(i);
        }
        return new NullableIntVector(name, data, mask);
    }

    private ValueVector readLongField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        BigIntVector vector = (BigIntVector)fieldVector;
        long[] data = new long[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = vector.get(i);
            }
            return new LongVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = vector.get(i);
        }
        return new NullableLongVector(name, data, mask);
    }

    private ValueVector readFloatField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        Float4Vector vector = (Float4Vector)fieldVector;
        float[] data = new float[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = vector.get(i);
            }
            return new FloatVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = vector.get(i);
        }
        return new NullableFloatVector(name, data, mask);
    }

    private ValueVector readDoubleField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        Float8Vector vector = (Float8Vector)fieldVector;
        double[] data = new double[count];
        if (!fieldVector.getField().isNullable()) {
            for (int i = 0; i < count; ++i) {
                data[i] = vector.get(i);
            }
            return new DoubleVector(name, data);
        }
        BitSet mask = new BitSet(count);
        for (int i = 0; i < count; ++i) {
            if (vector.isNull(i)) {
                mask.set(i);
                continue;
            }
            data[i] = vector.get(i);
        }
        return new NullableDoubleVector(name, data, mask);
    }

    private ValueVector readDecimalField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        Number[] data = new BigDecimal[count];
        DecimalVector vector = (DecimalVector)fieldVector;
        for (int i = 0; i < count; ++i) {
            data[i] = vector.isNull(i) ? null : vector.getObject(i);
        }
        StructField field = new StructField(name, DataTypes.DecimalType);
        return new NumberVector(field, data);
    }

    private ValueVector readDateField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        LocalDate[] data = new LocalDate[count];
        ZoneOffset zone = OffsetDateTime.now().getOffset();
        if (fieldVector instanceof DateDayVector) {
            DateDayVector vector = (DateDayVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                data[i] = vector.isNull(i) ? null : LocalDate.ofEpochDay(vector.get(i));
            }
        } else if (fieldVector instanceof DateMilliVector) {
            DateMilliVector vector = (DateMilliVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                data[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone).toLocalDate();
            }
        }
        StructField field = new StructField(name, DataTypes.DateType);
        return new ObjectVector<LocalDate>(field, data);
    }

    private ValueVector readTimeField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        LocalTime[] data = new LocalTime[count];
        FieldVector fieldVector2 = fieldVector;
        Objects.requireNonNull(fieldVector2);
        FieldVector fieldVector3 = fieldVector2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeNanoVector.class, TimeMilliVector.class, TimeMicroVector.class, TimeSecVector.class}, (Object)fieldVector3, n)) {
            case 0: {
                TimeNanoVector vector = (TimeNanoVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i));
                }
                break;
            }
            case 1: {
                TimeMilliVector vector = (TimeMilliVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay((long)vector.get(i) * 1000000L);
                }
                break;
            }
            case 2: {
                TimeMicroVector vector = (TimeMicroVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000L);
                }
                break;
            }
            case 3: {
                TimeSecVector vector = (TimeSecVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalTime.ofSecondOfDay(vector.get(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid field vector type: " + String.valueOf(fieldVector.getMinorType()));
            }
        }
        StructField field = new StructField(name, DataTypes.TimeType);
        return new ObjectVector<LocalTime>(field, data);
    }

    private ValueVector readDateTimeField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        LocalDateTime[] data = new LocalDateTime[count];
        String timezone = ((ArrowType.Timestamp)fieldVector.getField().getType()).getTimezone();
        ZoneOffset zone = timezone == null ? OffsetDateTime.now().getOffset() : ZoneOffset.of(timezone);
        FieldVector fieldVector2 = fieldVector;
        Objects.requireNonNull(fieldVector2);
        FieldVector fieldVector3 = fieldVector2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeStampMilliVector.class, TimeStampNanoVector.class, TimeStampMicroVector.class, TimeStampSecVector.class}, (Object)fieldVector3, n)) {
            case 0: {
                TimeStampMilliVector vector = (TimeStampMilliVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone);
                }
                break;
            }
            case 1: {
                TimeStampNanoVector vector = (TimeStampNanoVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000000L), zone);
                }
                break;
            }
            case 2: {
                TimeStampMicroVector vector = (TimeStampMicroVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000L), zone);
                }
                break;
            }
            case 3: {
                TimeStampSecVector vector = (TimeStampSecVector)fieldVector3;
                for (int i = 0; i < count; ++i) {
                    data[i] = vector.isNull(i) ? null : LocalDateTime.ofEpochSecond(vector.get(i), 0, zone);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid field vector type: " + String.valueOf(fieldVector.getMinorType()));
            }
        }
        StructField field = new StructField(name, DataTypes.DateTimeType);
        return new ObjectVector<LocalDateTime>(field, data);
    }

    private ValueVector readByteArrayField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        byte[][] data = new byte[count][];
        if (fieldVector instanceof VarBinaryVector) {
            VarBinaryVector vector = (VarBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                data[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else if (fieldVector instanceof FixedSizeBinaryVector) {
            FixedSizeBinaryVector vector = (FixedSizeBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                data[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported binary vector: " + String.valueOf(fieldVector));
        }
        StructField field = new StructField(name, DataTypes.ByteArrayType);
        return new ObjectVector(field, (T[])data);
    }

    private ValueVector readStringField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        String name = fieldVector.getField().getName();
        VarCharVector vector = (VarCharVector)fieldVector;
        String[] data = new String[count];
        for (int i = 0; i < count; ++i) {
            data[i] = vector.isNull(i) ? null : new String(vector.get(i));
        }
        return new StringVector(name, data);
    }

    private void writeIntField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableIntField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getInt(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableIntField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Integer x = (Integer)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.intValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeBooleanField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableBooleanField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getInt(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableBooleanField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Boolean x = (Boolean)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x != false ? 1 : 0);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeCharField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableCharField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getChar(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableCharField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Character x = (Character)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.charValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableByteField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getByte(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableByteField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Byte x = (Byte)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.byteValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeShortField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableShortField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getShort(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableShortField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Short x = (Short)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.shortValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeLongField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableLongField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getLong(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableLongField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Long x = (Long)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.longValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeFloatField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableFloatField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getFloat(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableFloatField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Float x = (Float)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.floatValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDoubleField(DataFrame df, FieldVector fieldVector, int from, int count) {
        ValueVector column = df.column(fieldVector.getField().getName());
        if (column.isNullable()) {
            this.writeNullableDoubleField(df, fieldVector, from, count);
            return;
        }
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getDouble(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeNullableDoubleField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Double x = (Double)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.doubleValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeStringField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarCharVector vector = (VarCharVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            String x = (String)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.getBytes(StandardCharsets.UTF_8));
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDecimalField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DecimalVector vector = (DecimalVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            BigDecimal x = (BigDecimal)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDateField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DateDayVector vector = (DateDayVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDate x = (LocalDate)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, (int)x.toEpochDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeTimeField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeNanoVector vector = (TimeNanoVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalTime x = (LocalTime)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toNanoOfDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDateTimeField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeStampMilliTZVector vector = (TimeStampMilliTZVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDateTime x = (LocalDateTime)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteArrayField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarBinaryVector vector = (VarBinaryVector)fieldVector;
        ValueVector column = df.column(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            byte[] bytes = (byte[])column.get(j);
            if (bytes == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, bytes);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    public static DataType toDataType(Field field) {
        ArrowType type = field.getType();
        boolean nullable = field.isNullable();
        return switch (type.getTypeID()) {
            case ArrowType.ArrowTypeID.Int -> {
                ArrowType.Int itype = (ArrowType.Int)type;
                int bitWidth = itype.getBitWidth();
                switch (bitWidth) {
                    case 8: {
                        if (nullable) {
                            yield DataTypes.NullableByteType;
                        }
                        yield DataTypes.ByteType;
                    }
                    case 16: {
                        if (nullable) {
                            yield DataTypes.NullableShortType;
                        }
                        yield DataTypes.ShortType;
                    }
                    case 32: {
                        if (nullable) {
                            yield DataTypes.NullableIntType;
                        }
                        yield DataTypes.IntType;
                    }
                    case 64: {
                        if (nullable) {
                            yield DataTypes.NullableLongType;
                        }
                        yield DataTypes.LongType;
                    }
                }
                throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
            }
            case ArrowType.ArrowTypeID.FloatingPoint -> {
                FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                switch (precision) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOUBLE: {
                        if (nullable) {
                            yield DataTypes.NullableDoubleType;
                        }
                        yield DataTypes.DoubleType;
                    }
                    case SINGLE: {
                        if (nullable) {
                            yield DataTypes.NullableFloatType;
                        }
                        yield DataTypes.FloatType;
                    }
                    case HALF: 
                }
                throw new UnsupportedOperationException("Unsupported float precision: " + String.valueOf(precision));
            }
            case ArrowType.ArrowTypeID.Bool -> DataTypes.BooleanType;
            case ArrowType.ArrowTypeID.Decimal -> DataTypes.DecimalType;
            case ArrowType.ArrowTypeID.Utf8 -> DataTypes.StringType;
            case ArrowType.ArrowTypeID.Date -> DataTypes.DateType;
            case ArrowType.ArrowTypeID.Time -> DataTypes.TimeType;
            case ArrowType.ArrowTypeID.Timestamp -> DataTypes.DateTimeType;
            case ArrowType.ArrowTypeID.Binary, ArrowType.ArrowTypeID.FixedSizeBinary -> DataTypes.ByteArrayType;
            case ArrowType.ArrowTypeID.List, ArrowType.ArrowTypeID.FixedSizeList -> {
                List child = field.getChildren();
                if (child.size() != 1) {
                    throw new IllegalStateException(String.format("List type has %d child fields.", child.size()));
                }
                yield DataTypes.array(Arrow.toStructField((Field)child.getFirst()).dtype());
            }
            case ArrowType.ArrowTypeID.Struct -> {
                List<StructField> children = field.getChildren().stream().map(Arrow::toStructField).toList();
                yield new StructType(children);
            }
            default -> throw new UnsupportedOperationException("Unsupported arrow to smile type conversion: " + String.valueOf(type));
        };
    }

    public static StructField toStructField(Field field) {
        String name = field.getName();
        DataType dtype = Arrow.toDataType(field);
        return new StructField(name, dtype);
    }

    public static Field toArrow(StructField field) {
        String name = field.name();
        DataType dtype = field.dtype();
        return switch (dtype.id()) {
            default -> throw new MatchException(null, null);
            case DataType.ID.Int -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.Int(32, true), null), null);
            case DataType.ID.Long -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.Int(64, true), null), null);
            case DataType.ID.Double -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null);
            case DataType.ID.Float -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null);
            case DataType.ID.Boolean -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.Bool(), null), null);
            case DataType.ID.Byte -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.Int(8, true), null), null);
            case DataType.ID.Short -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.Int(16, true), null), null);
            case DataType.ID.Char -> new Field(name, new FieldType(dtype.isNullable(), (ArrowType)new ArrowType.Int(16, false), null), null);
            case DataType.ID.Decimal -> new Field(name, FieldType.nullable((ArrowType)new ArrowType.Decimal(28, 10, 128)), null);
            case DataType.ID.String -> new Field(name, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
            case DataType.ID.Date -> new Field(name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)), null);
            case DataType.ID.Time -> new Field(name, FieldType.nullable((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)), null);
            case DataType.ID.DateTime -> new Field(name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, ZoneOffset.UTC.getId())), null);
            case DataType.ID.Object -> {
                Class<?> clazz = ((ObjectType)dtype).getObjectClass();
                if (clazz == Integer.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
                }
                if (clazz == Long.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), null);
                }
                if (clazz == Double.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), null);
                }
                if (clazz == Float.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), null);
                }
                if (clazz == Boolean.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Bool()), null);
                }
                if (clazz == Byte.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), null);
                }
                if (clazz == Short.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null);
                }
                if (clazz == Character.class) {
                    yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Int(16, false)), null);
                }
                throw new UnsupportedOperationException("Unsupported arrow type conversion: " + clazz.getName());
            }
            case DataType.ID.Array -> {
                DataType etype = ((ArrayType)dtype).getComponentType();
                switch (etype.id()) {
                    case Int: {
                        yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null)));
                    }
                    case Long: {
                        yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null)));
                    }
                    case Double: {
                        yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null)));
                    }
                    case Float: {
                        yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null)));
                    }
                    case Boolean: {
                        yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null)));
                    }
                    case Byte: {
                        yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Binary()), null);
                    }
                    case Short: {
                        yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null)));
                    }
                    case Char: {
                        yield new Field(name, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
                    }
                }
                throw new UnsupportedOperationException("Unsupported array type conversion: " + String.valueOf(etype));
            }
            case DataType.ID.Struct -> {
                StructType children = (StructType)dtype;
                yield new Field(name, new FieldType(false, (ArrowType)new ArrowType.Struct(), null), children.fields().stream().map(Arrow::toArrow).toList());
            }
        };
    }

    public static StructType toStructType(Schema schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (Field field : schema.getFields()) {
            fields.add(Arrow.toStructField(field));
        }
        return new StructType(fields);
    }

    public static Schema toArrow(StructType schema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (StructField field : schema.fields()) {
            fields.add(Arrow.toArrow(field));
        }
        return new Schema(fields, null);
    }
}

