/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.Matern;
import smile.math.kernel.MercerKernel;

public class BinarySparseMaternKernel
extends Matern
implements MercerKernel<int[]> {
    public BinarySparseMaternKernel(double sigma, double nu) {
        this(sigma, nu, 1.0E-5, 100000.0);
    }

    public BinarySparseMaternKernel(double sigma, double nu, double lo, double hi) {
        super(sigma, nu, lo, hi);
    }

    @Override
    public double k(int[] x, int[] y) {
        return this.k(MathEx.distance(x, y));
    }

    @Override
    public double[] kg(int[] x, int[] y) {
        return this.kg(MathEx.distance(x, y));
    }

    public BinarySparseMaternKernel of(double[] params) {
        return new BinarySparseMaternKernel(params[0], this.nu, this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.sigma};
    }

    @Override
    public double[] lo() {
        return new double[]{this.lo};
    }

    @Override
    public double[] hi() {
        return new double[]{this.hi};
    }
}

