/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import java.lang.reflect.Array;
import java.util.Arrays;
import smile.sort.Sort;

public class HeapSelect<T extends Comparable<? super T>> {
    private final int k;
    private final T[] heap;
    private int n;
    private boolean sorted;

    public HeapSelect(Class<?> clazz, int k) {
        this.heap = (Comparable[])Array.newInstance(clazz, k + 1);
        this.k = k;
        this.n = 0;
        this.sorted = false;
    }

    public int size() {
        return this.n;
    }

    public T[] toArray() {
        return (Comparable[])Arrays.copyOfRange(this.heap, 1, Math.min(this.k, this.n) + 1);
    }

    public T[] toArray(T[] a) {
        System.arraycopy(this.heap, 1, a, 0, Math.min(this.k, this.n));
        return a;
    }

    public void add(T datum) {
        this.sorted = false;
        if (this.n < this.k) {
            this.heap[++this.n] = datum;
            Sort.siftUp(this.heap, (int)this.n);
        } else {
            ++this.n;
            if (datum.compareTo(this.heap[1]) < 0) {
                this.heap[1] = datum;
                Sort.siftDown(this.heap, (int)1, (int)this.k);
            }
        }
    }

    public void siftDown() {
        Sort.siftDown(this.heap, (int)1, (int)Math.min(this.k, this.n));
    }

    public T peek() {
        return this.heap[1];
    }

    public T get(int i) {
        int len = Math.min(this.k, this.n);
        if (i > len - 1) {
            throw new IllegalArgumentException("HeapSelect i is greater than the number of data received so far.");
        }
        if (i == len - 1) {
            return this.heap[1];
        }
        this.sort();
        return this.heap[len - i];
    }

    public void sort() {
        if (!this.sorted) {
            HeapSelect.sort(this.heap, (int)1, (int)Math.min(this.k, this.n));
            this.sorted = true;
        }
    }

    private static <T extends Comparable<? super T>> void heapify(T[] arr, int n) {
        for (int i = n / 2; i >= 1; --i) {
            Sort.siftDown(arr, (int)i, (int)n);
        }
    }

    private static <T extends Comparable<? super T>> void sort(T[] a, int l, int r) {
        int h = 1;
        while (h <= (r - l) / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = l + h; i <= r; ++i) {
                int j = i;
                T v = a[i];
                while (j >= l + h && a[j - h].compareTo(v) < 0) {
                    a[j] = a[j - h];
                    a[j -= h] = v;
                }
            }
            h /= 3;
        }
    }
}

