/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.io.Serializable;
import smile.math.MathEx;

public interface Distribution
extends Serializable {
    public int length();

    public double mean();

    public double variance();

    default public double sd() {
        return Math.sqrt(this.variance());
    }

    public double entropy();

    public double rand();

    default public double[] rand(int n) {
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.rand();
        }
        return data;
    }

    public double p(double var1);

    public double logp(double var1);

    public double cdf(double var1);

    public double quantile(double var1);

    default public double likelihood(double[] x) {
        return Math.exp(this.logLikelihood(x));
    }

    default public double logLikelihood(double[] x) {
        double L = 0.0;
        for (double xi : x) {
            L += this.logp(xi);
        }
        return L;
    }

    default public double rejectionSampling(double pmax, double xmin, double xmax) {
        double y;
        double x;
        do {
            x = xmin + MathEx.random() * (xmax - xmin);
            y = MathEx.random() * pmax;
        } while (this.p(x) < y);
        return x;
    }

    default public double inverseTransformSampling() {
        double u = MathEx.random();
        return this.quantile(u);
    }

    default public double quantile(double p, double xmin, double xmax, double eps) {
        if (eps <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + eps);
        }
        while (Math.abs(xmax - xmin) > eps) {
            double xmed = (xmax + xmin) / 2.0;
            if (this.cdf(xmed) > p) {
                xmax = xmed;
                continue;
            }
            xmin = xmed;
        }
        return xmin;
    }

    default public double quantile(double p, double xmin, double xmax) {
        return this.quantile(p, xmin, xmax, 1.0E-6);
    }
}

