/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;
import smile.math.MathEx;

public class Array2D {
    private final double[] A;
    private final int nrow;
    private final int ncol;

    public Array2D(double[][] A) {
        this.nrow = A.length;
        this.ncol = A[0].length;
        this.A = new double[this.nrow * this.ncol];
        int pos = 0;
        for (int i = 0; i < this.nrow; ++i) {
            System.arraycopy(A[i], 0, this.A, pos, this.ncol);
            pos += this.ncol;
        }
    }

    public Array2D(int nrow, int ncol) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.A = new double[ncol * ncol];
    }

    public Array2D(int nrow, int ncol, double value) {
        this(nrow, ncol);
        if (value != 0.0) {
            Arrays.fill(this.A, value);
        }
    }

    public Array2D(int nrow, int ncol, double[] value) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.A = value;
    }

    public int nrow() {
        return this.nrow;
    }

    public int ncol() {
        return this.ncol;
    }

    public double apply(int i, int j) {
        return this.A[i * this.ncol + j];
    }

    public double get(int i, int j) {
        return this.A[i * this.ncol + j];
    }

    public void set(int i, int j, double x) {
        this.A[i * this.ncol + j] = x;
    }

    public double add(int i, int j, double x) {
        int n = i * this.ncol + j;
        double d = this.A[n] + x;
        this.A[n] = d;
        return d;
    }

    public double sub(int i, int j, double x) {
        int n = i * this.ncol + j;
        double d = this.A[n] - x;
        this.A[n] = d;
        return d;
    }

    public double mul(int i, int j, double x) {
        int n = i * this.ncol + j;
        double d = this.A[n] * x;
        this.A[n] = d;
        return d;
    }

    public double div(int i, int j, double x) {
        int n = i * this.ncol + j;
        double d = this.A[n] / x;
        this.A[n] = d;
        return d;
    }

    public Array2D add(Array2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + B.A[i];
        }
        return this;
    }

    public Array2D sub(Array2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - B.A[i];
        }
        return this;
    }

    public Array2D mul(Array2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * B.A[i];
        }
        return this;
    }

    public Array2D div(Array2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / B.A[i];
        }
        return this;
    }

    public Array2D add(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    public Array2D sub(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    public Array2D mul(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    public Array2D div(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    public Array2D replaceNaN(double x) {
        for (int i = 0; i < this.A.length; ++i) {
            if (!Double.isNaN(this.A[i])) continue;
            this.A[i] = x;
        }
        return this;
    }

    public double sum() {
        return MathEx.sum(this.A);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        return full ? this.toString(this.nrow, this.ncol) : this.toString(7, 7);
    }

    public String toString(int m, int n) {
        StringBuilder sb = new StringBuilder();
        m = Math.min(m, this.nrow);
        String newline = (n = Math.min(n, this.ncol)) < this.ncol ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%8.4f  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrow) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }
}

