/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import smile.data.Attribute;

public class DateAttribute
extends Attribute {
    private DateFormat format;

    public DateAttribute(String name) {
        this(name, 1.0);
    }

    public DateAttribute(String name, double weight) {
        this(name, null, weight);
    }

    public DateAttribute(String name, String description, double weight) {
        super(Attribute.Type.DATE, name, description, weight);
        this.format = new SimpleDateFormat();
    }

    public DateAttribute(String name, String description, String format) {
        super(Attribute.Type.DATE, name, description);
        this.format = new SimpleDateFormat(format);
    }

    public DateAttribute(String name, String description, double weight, String format) {
        super(Attribute.Type.DATE, name, description, weight);
        this.format = new SimpleDateFormat(format);
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = new SimpleDateFormat(format);
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public String toString(Date date) {
        return this.format.format(date);
    }

    public double valueOf(Date date) {
        return Double.longBitsToDouble(date.getTime());
    }

    public String toString(double x) {
        if (Double.isNaN(x)) {
            return null;
        }
        return this.format.format(Double.doubleToRawLongBits(x));
    }

    public double valueOf(String s) throws ParseException {
        Date d = this.format.parse(s);
        return Double.longBitsToDouble(d.getTime());
    }
}

