/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.DateAttribute;
import smile.data.Datum;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.data.StringAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArffParser {
    private static final String ARFF_RELATION = "@relation";
    private static final String ARFF_DATA = "@data";
    private static final String ARFF_ATTRIBUTE = "@attribute";
    private static final String ARFF_ATTRIBUTE_INTEGER = "integer";
    private static final String ARFF_ATTRIBUTE_REAL = "real";
    private static final String ARFF_ATTRIBUTE_NUMERIC = "numeric";
    private static final String ARFF_ATTRIBUTE_STRING = "string";
    private static final String ARFF_ATTRIBUTE_DATE = "date";
    private static final String ARFF_ATTRIBUTE_RELATIONAL = "relational";
    private static final String ARFF_END_SUBRELATION = "@end";
    private int responseIndex = -1;

    public int getResponseIndex() {
        return this.responseIndex;
    }

    public void setResponseIndex(int index) {
        this.responseIndex = index;
    }

    private void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.commentChar(37);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.eolIsSignificant(true);
    }

    private void getFirstToken(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    private void getLastToken(StreamTokenizer tokenizer, boolean endOfFileOk) throws IOException, ParseException {
        if (!(tokenizer.nextToken() == 10 || tokenizer.ttype == -1 && endOfFileOk)) {
            throw new ParseException("end of line expected", tokenizer.lineno());
        }
    }

    private void getNextToken(StreamTokenizer tokenizer) throws IOException, ParseException {
        if (tokenizer.nextToken() == 10) {
            throw new ParseException("premature end of line", tokenizer.lineno());
        }
        if (tokenizer.ttype == -1) {
            throw new ParseException("premature end of file", tokenizer.lineno());
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    private String readHeader(StreamTokenizer tokenizer, List<Attribute> attributes) throws IOException, ParseException {
        String relationName = null;
        attributes.clear();
        this.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            throw new ParseException("premature end of file", tokenizer.lineno());
        }
        if (!ARFF_RELATION.equalsIgnoreCase(tokenizer.sval)) {
            throw new ParseException("keyword @relation expected", tokenizer.lineno());
        }
        this.getNextToken(tokenizer);
        relationName = tokenizer.sval;
        this.getLastToken(tokenizer, false);
        this.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            throw new ParseException("premature end of file", tokenizer.lineno());
        }
        while (ARFF_ATTRIBUTE.equalsIgnoreCase(tokenizer.sval)) {
            attributes.add(this.parseAttribute(tokenizer));
        }
        if (!ARFF_DATA.equalsIgnoreCase(tokenizer.sval)) {
            throw new ParseException("keyword @data expected", tokenizer.lineno());
        }
        if (attributes.isEmpty()) {
            throw new ParseException("no attributes declared", tokenizer.lineno());
        }
        if (this.responseIndex >= attributes.size()) {
            throw new ParseException("Invalid response variable index", this.responseIndex);
        }
        return relationName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Attribute parseAttribute(StreamTokenizer tokenizer) throws IOException, ParseException {
        Object var2_2 = null;
        this.getNextToken(tokenizer);
        String attributeName = tokenizer.sval;
        this.getNextToken(tokenizer);
        if (tokenizer.ttype == -3) {
            if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_REAL) || tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_INTEGER) || tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_NUMERIC)) {
                NumericAttribute numericAttribute = new NumericAttribute(attributeName);
                this.readTillEOL(tokenizer);
            } else if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_STRING)) {
                StringAttribute stringAttribute = new StringAttribute(attributeName);
                this.readTillEOL(tokenizer);
            } else if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_DATE)) {
                String format = null;
                if (tokenizer.nextToken() != 10) {
                    if (tokenizer.ttype != -3 && tokenizer.ttype != 39 && tokenizer.ttype != 34) {
                        throw new ParseException("not a valid date format", tokenizer.lineno());
                    }
                    format = tokenizer.sval;
                    this.readTillEOL(tokenizer);
                } else {
                    tokenizer.pushBack();
                }
                DateAttribute dateAttribute = new DateAttribute(attributeName, null, format);
                this.readTillEOL(tokenizer);
            } else if (tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_RELATIONAL)) {
                this.readTillEOL(tokenizer);
            } else {
                if (!tokenizer.sval.equalsIgnoreCase(ARFF_END_SUBRELATION)) throw new ParseException("Invalid attribute type or invalid enumeration", tokenizer.lineno());
                this.getNextToken(tokenizer);
            }
        } else {
            ArrayList<String> attributeValues = new ArrayList<String>();
            tokenizer.pushBack();
            if (tokenizer.nextToken() != 123) {
                throw new ParseException("{ expected at beginning of enumeration", tokenizer.lineno());
            }
            while (tokenizer.nextToken() != 125) {
                if (tokenizer.ttype == 10) {
                    throw new ParseException("} expected at end of enumeration", tokenizer.lineno());
                }
                attributeValues.add(tokenizer.sval.trim());
            }
            String[] values = new String[attributeValues.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (String)attributeValues.get(i);
            }
            NominalAttribute nominalAttribute = new NominalAttribute(attributeName, values);
        }
        this.getLastToken(tokenizer, false);
        this.getFirstToken(tokenizer);
        if (tokenizer.ttype != -1) void var2_7;
        return var2_7;
        throw new ParseException("premature end of file", tokenizer.lineno());
    }

    private void readTillEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }

    public static Attribute[] getAttributes(URI uri) throws FileNotFoundException, IOException, ParseException {
        return ArffParser.getAttributes(new File(uri));
    }

    public static Attribute[] getAttributes(String path) throws FileNotFoundException, IOException, ParseException {
        return ArffParser.getAttributes(new File(path));
    }

    public static Attribute[] getAttributes(File file) throws FileNotFoundException, IOException, ParseException {
        return ArffParser.getAttributes(new FileInputStream(file));
    }

    public static Attribute[] getAttributes(InputStream stream) throws IOException, ParseException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        StreamTokenizer tokenizer = new StreamTokenizer(r);
        ArffParser parser = new ArffParser();
        parser.initTokenizer(tokenizer);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        parser.readHeader(tokenizer, attributes);
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    public AttributeDataset parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new FileInputStream(file));
    }

    public AttributeDataset parse(InputStream stream) throws IOException, ParseException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        StreamTokenizer tokenizer = new StreamTokenizer(r);
        this.initTokenizer(tokenizer);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String relationName = this.readHeader(tokenizer, attributes);
        if (attributes.isEmpty()) {
            throw new IOException("no header information available");
        }
        Attribute response = null;
        Attribute[] attr = new Attribute[attributes.size()];
        attributes.toArray(attr);
        for (int i = 0; i < attributes.size(); ++i) {
            if (this.responseIndex != i) continue;
            response = (Attribute)attributes.remove(i);
            break;
        }
        AttributeDataset data = new AttributeDataset(relationName, attributes.toArray(new Attribute[attributes.size()]), response);
        while (true) {
            this.getFirstToken(tokenizer);
            if (tokenizer.ttype == -1) break;
            if (tokenizer.ttype == 123) {
                data.add(this.getSparseInstance(tokenizer, attr));
                continue;
            }
            data.add(this.getInstance(tokenizer, attr));
        }
        stream.close();
        for (Attribute attribute : attributes) {
            Attribute a;
            if (attribute instanceof NominalAttribute) {
                a = (NominalAttribute)attribute;
                ((NominalAttribute)a).setOpen(false);
            }
            if (!(attribute instanceof StringAttribute)) continue;
            a = (StringAttribute)attribute;
            ((StringAttribute)a).setOpen(false);
        }
        return data;
    }

    private Datum<double[]> getInstance(StreamTokenizer tokenizer, Attribute[] attributes) throws IOException, ParseException {
        double[] x = this.responseIndex >= 0 ? new double[attributes.length - 1] : new double[attributes.length];
        double y = Double.NaN;
        int k = 0;
        for (int i = 0; i < attributes.length; ++i) {
            if (i > 0) {
                this.getNextToken(tokenizer);
            }
            if (i == this.responseIndex) {
                if (tokenizer.ttype == 63) {
                    y = Double.NaN;
                    continue;
                }
                y = attributes[i].valueOf(tokenizer.sval);
                continue;
            }
            x[k++] = tokenizer.ttype == 63 ? Double.NaN : attributes[i].valueOf(tokenizer.sval);
        }
        return new Datum<double[]>(x, y);
    }

    private Datum<double[]> getSparseInstance(StreamTokenizer tokenizer, Attribute[] attributes) throws IOException, ParseException {
        double[] x = this.responseIndex >= 0 ? new double[attributes.length - 1] : new double[attributes.length];
        double y = Double.NaN;
        int index = -1;
        do {
            this.getNextToken(tokenizer);
            if (tokenizer.ttype == 125) break;
            String s = tokenizer.sval.trim();
            if (index < 0) {
                index = Integer.valueOf(s);
                if (index >= 0 && index < attributes.length) continue;
                throw new ParseException("Invalid attribute index: " + index, tokenizer.lineno());
            }
            String val = s;
            if (index != this.responseIndex) {
                x[index] = val.equals("?") ? Double.NaN : attributes[index].valueOf(val);
            } else {
                y = val.equals("?") ? Double.NaN : attributes[index].valueOf(val);
            }
            index = -1;
        } while (tokenizer.ttype == -3);
        return new Datum<double[]>(x, y);
    }
}

