/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser.microarray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.Datum;
import smile.data.NumericAttribute;

public class RESParser {
    public AttributeDataset parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String name, URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public AttributeDataset parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(String name, String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public AttributeDataset parse(File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(file.getPath(), new FileInputStream(file));
    }

    public AttributeDataset parse(String name, File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(String name, InputStream stream) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Empty data source.");
        }
        String[] tokens = line.split("\t", -1);
        int p = (tokens.length - 2) / 2;
        line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature end of file.");
        }
        String[] samples = line.split("\t", -1);
        if (samples.length != tokens.length - 1) {
            throw new IOException("Invalid sample description header.");
        }
        Attribute[] attributes = new Attribute[p];
        for (int i = 0; i < p; ++i) {
            attributes[i] = new NumericAttribute(tokens[2 * i + 2], samples[2 * i + 1]);
        }
        line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature end of file.");
        }
        int n = Integer.valueOf(line);
        if (n <= 0) {
            throw new IOException("Invalid number of rows: " + n);
        }
        AttributeDataset data = new AttributeDataset(name, attributes);
        for (int i = 0; i < n; ++i) {
            line = reader.readLine();
            if (line == null) {
                throw new IOException("Premature end of file.");
            }
            tokens = line.split("\t", -1);
            if (tokens.length != samples.length + 1) {
                throw new IOException(String.format("Invalid number of elements of line %d: %d", i + 4, tokens.length));
            }
            double[] x = new double[p];
            for (int j = 0; j < p; ++j) {
                x[j] = Double.valueOf(tokens[2 * j + 2]);
            }
            Datum<double[]> datum = new Datum<double[]>(x);
            datum.name = tokens[1];
            datum.description = tokens[0];
            data.add(datum);
        }
        reader.close();
        return data;
    }
}

