/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Arrays;
import smile.data.Attribute;
import smile.data.Dataset;
import smile.data.Datum;
import smile.math.Math;
import smile.math.matrix.SparseMatrix;

public class BinarySparseDataset
extends Dataset<int[]> {
    private int n;
    private int numColumns;
    private int[] colSize;

    public BinarySparseDataset() {
        this("Binary Sparse Dataset");
    }

    public BinarySparseDataset(String name) {
        super(name);
        this.numColumns = 0;
        this.colSize = new int[100];
    }

    public BinarySparseDataset(String name, Attribute response) {
        super(name, response);
        this.numColumns = 0;
        this.colSize = new int[100];
    }

    public BinarySparseDataset(int ncols) {
        this.numColumns = ncols;
        this.colSize = new int[ncols];
    }

    public int ncols() {
        return this.numColumns;
    }

    @Override
    public void add(Datum<int[]> datum) {
        int[] x;
        for (int xi : x = (int[])datum.x) {
            if (xi >= 0) continue;
            throw new IllegalArgumentException("Negative index of nonzero element: " + xi);
        }
        Arrays.sort(x);
        for (int i = 1; i < x.length; ++i) {
            if (x[i] != x[i - 1]) continue;
            throw new IllegalArgumentException("Duplicated indices of nonzero elements: " + x[i]);
        }
        this.n += x.length;
        int max = Math.max((int[])x);
        if (this.numColumns <= max) {
            this.numColumns = max + 1;
            if (this.numColumns > this.colSize.length) {
                int[] size = new int[3 * this.numColumns / 2];
                System.arraycopy(this.colSize, 0, size, 0, this.colSize.length);
                this.colSize = size;
            }
        }
        int[] nArray = x;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int xi;
            int n2 = xi = nArray[i];
            this.colSize[n2] = this.colSize[n2] + 1;
        }
        super.add(datum);
    }

    public int get(int i, int j) {
        if (i < 0 || i >= this.size()) {
            throw new IllegalArgumentException("Invalid index: i = " + i);
        }
        int[] x = (int[])this.get((int)i).x;
        if (x.length == 0) {
            return 0;
        }
        int low = 0;
        int high = x.length - 1;
        int mid = (low + high) / 2;
        while (j != x[mid] && low <= high) {
            mid = (low + high) / 2;
            if (j < x[mid]) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (j == x[mid]) {
            return 1;
        }
        return 0;
    }

    public SparseMatrix toSparseMatrix() {
        int[] pos = new int[this.numColumns];
        int[] colIndex = new int[this.numColumns + 1];
        for (int i = 0; i < this.numColumns; ++i) {
            colIndex[i + 1] = colIndex[i] + this.colSize[i];
        }
        int nrows = this.size();
        int[] rowIndex = new int[this.n];
        double[] x = new double[this.n];
        for (int i = 0; i < nrows; ++i) {
            for (int j : (int[])this.get((int)i).x) {
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = 1.0;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrows, this.numColumns, x, rowIndex, colIndex);
    }
}

