/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NumericAttribute;

public class DelimitedTextParser {
    private String delimiter = "\\s+";
    private String comment = "%";
    private String missing = "?";
    private boolean hasColumnNames = false;
    private boolean hasRowNames = false;
    private Attribute response = null;
    private int responseIndex = -1;
    private List<Integer> ignoredColumns = new ArrayList<Integer>();

    public String getDelimiter() {
        return this.delimiter;
    }

    public DelimitedTextParser setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public String getCommentStartWith() {
        return this.comment;
    }

    public DelimitedTextParser setCommentStartWith(String comment) {
        this.comment = comment;
        return this;
    }

    public String getMissingValuePlaceholder() {
        return this.missing;
    }

    public DelimitedTextParser setMissingValuePlaceholder(String missing) {
        this.missing = missing;
        return this;
    }

    public DelimitedTextParser setResponseIndex(Attribute response, int index) {
        if (response.getType() != Attribute.Type.NOMINAL && response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric or nominal.");
        }
        this.response = response;
        this.responseIndex = index;
        return this;
    }

    public DelimitedTextParser setIgnoredColumns(List<Integer> ignoredColumns) {
        this.ignoredColumns = ignoredColumns;
        return this;
    }

    public DelimitedTextParser addIgnoredColumn(int index) {
        this.ignoredColumns.add(index);
        return this;
    }

    public DelimitedTextParser addIgnoredColumns(List<Integer> ignoredColumns) {
        this.ignoredColumns.addAll(ignoredColumns);
        return this;
    }

    public boolean hasRowNames() {
        return this.hasRowNames;
    }

    public DelimitedTextParser setRowNames(boolean hasRowNames) {
        this.hasRowNames = hasRowNames;
        return this;
    }

    public boolean hasColumnNames() {
        return this.hasColumnNames;
    }

    public DelimitedTextParser setColumnNames(boolean hasColNames) {
        this.hasColumnNames = hasColNames;
        return this;
    }

    public AttributeDataset parse(URI uri) throws IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String name, Attribute[] attributes, URI uri) throws IOException, ParseException {
        return this.parse(name, attributes, new File(uri));
    }

    public AttributeDataset parse(String path) throws IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(Attribute[] attributes, String path) throws IOException, ParseException {
        return this.parse(attributes, new File(path));
    }

    public AttributeDataset parse(String name, Attribute[] attributes, String path) throws IOException, ParseException {
        return this.parse(name, attributes, new File(path));
    }

    public AttributeDataset parse(File file) throws IOException, ParseException {
        String name = file.getPath();
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(String name, File file) throws IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(Attribute[] attributes, File file) throws IOException, ParseException {
        String name = file.getPath();
        return this.parse(name, attributes, file);
    }

    public AttributeDataset parse(String name, Attribute[] attributes, File file) throws IOException, ParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            AttributeDataset attributeDataset = this.parse(name, attributes, reader);
            return attributeDataset;
        }
    }

    public AttributeDataset parse(String name, InputStream stream) throws IOException, ParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            AttributeDataset attributeDataset = this.parse(name, null, reader);
            return attributeDataset;
        }
    }

    private AttributeDataset parse(String name, Attribute[] attributes, BufferedReader reader) throws IOException, ParseException {
        AttributeDataset.Row datum;
        int k;
        double y;
        String[] s;
        int p;
        String line = reader.readLine();
        while (line != null && (line.isEmpty() || line.startsWith(this.comment))) {
            line = reader.readLine();
        }
        if (line == null) {
            throw new IOException("Empty data source.");
        }
        if (this.hasRowNames) {
            this.addIgnoredColumn(0);
        }
        if ((p = (s = line.split(this.delimiter, 0)).length - this.ignoredColumns.size()) <= 0) {
            throw new IllegalArgumentException("There are more ignored columns (" + this.ignoredColumns.size() + ") than columns in the file (" + s.length + ").");
        }
        if (this.responseIndex >= s.length) {
            throw new ParseException("Invalid response variable index: " + this.responseIndex, this.responseIndex);
        }
        if (this.ignoredColumns.contains(this.responseIndex)) {
            throw new IllegalArgumentException("The response variable is present in the list of ignored columns.");
        }
        if (p == 1) {
            throw new IllegalArgumentException("All columns are ignored, except the response variable.");
        }
        if (this.responseIndex >= 0) {
            --p;
        }
        if (attributes == null) {
            attributes = new Attribute[p];
            int k2 = 0;
            for (int i = 0; i < s.length; ++i) {
                if (this.ignoredColumns.contains(i) || i == this.responseIndex) continue;
                attributes[k2++] = new NumericAttribute("V" + (i + 1));
            }
        }
        int ncols = attributes.length;
        if (this.responseIndex >= 0) {
            ++ncols;
        }
        if ((ncols += this.ignoredColumns.size()) != s.length) {
            throw new ParseException(String.format("%d columns, expected %d", s.length, ncols), s.length);
        }
        AttributeDataset data = new AttributeDataset(name, attributes, this.response);
        if (this.hasColumnNames) {
            int k3 = 0;
            for (int i = 0; i < s.length; ++i) {
                if (this.ignoredColumns.contains(i)) continue;
                if (i != this.responseIndex) {
                    attributes[k3++].setName(s[i]);
                    continue;
                }
                this.response.setName(s[i]);
            }
        } else {
            String rowName = this.hasRowNames ? s[0] : null;
            double[] x = new double[attributes.length];
            y = Double.NaN;
            k = 0;
            for (int i = 0; i < s.length; ++i) {
                if (this.ignoredColumns.contains(i)) continue;
                if (i == this.responseIndex) {
                    y = this.response.valueOf(s[i]);
                    continue;
                }
                if (this.missing != null && this.missing.equalsIgnoreCase(s[i])) {
                    x[k++] = Double.NaN;
                    continue;
                }
                x[k] = attributes[k].valueOf(s[i]);
                ++k;
            }
            datum = Double.isNaN(y) ? data.add(x) : data.add(x, y);
            datum.name = rowName;
        }
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.startsWith(this.comment)) continue;
            s = line.split(this.delimiter, 0);
            if (s.length != ncols) {
                throw new ParseException(String.format("%d columns, expected %d", s.length, ncols), s.length);
            }
            String rowName = this.hasRowNames ? s[0] : null;
            double[] x = new double[attributes.length];
            y = Double.NaN;
            k = 0;
            for (int i = 0; i < s.length; ++i) {
                if (this.ignoredColumns.contains(i)) continue;
                if (i == this.responseIndex) {
                    y = this.response.valueOf(s[i]);
                    continue;
                }
                if (this.missing != null && this.missing.equalsIgnoreCase(s[i])) {
                    x[k++] = Double.NaN;
                    continue;
                }
                x[k] = attributes[k].valueOf(s[i]);
                ++k;
            }
            datum = Double.isNaN(y) ? data.add(x) : data.add(x, y);
            datum.name = rowName;
        }
        return data;
    }
}

