/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.HyperTerm;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.Vector;

public interface Term
extends HyperTerm {
    default public List<Term> terms() {
        return Collections.singletonList(this);
    }

    public String name();

    public DataType type();

    default public Optional<Measure> measure() {
        return Optional.empty();
    }

    default public StructField field() {
        return new StructField(this.name(), this.type(), this.measure().orElse(null));
    }

    public Object apply(Tuple var1);

    default public double applyAsDouble(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public float applyAsFloat(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public int applyAsInt(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public long applyAsLong(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public boolean applyAsBoolean(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public byte applyAsByte(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public short applyAsShort(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public char applyAsChar(Tuple o) {
        throw new UnsupportedOperationException();
    }

    default public boolean isVariable() {
        return false;
    }

    default public boolean isConstant() {
        return false;
    }

    default public BaseVector apply(DataFrame df) {
        if (this.isVariable()) {
            return df.column(this.name());
        }
        int size = df.size();
        switch (this.type().id()) {
            case Integer: {
                int[] values = new int[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsInt((Tuple)df.get(i));
                }
                return IntVector.of(this.field(), values);
            }
            case Long: {
                long[] values = new long[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsLong((Tuple)df.get(i));
                }
                return LongVector.of(this.field(), values);
            }
            case Double: {
                double[] values = new double[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsDouble((Tuple)df.get(i));
                }
                return DoubleVector.of(this.field(), values);
            }
            case Float: {
                float[] values = new float[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsFloat((Tuple)df.get(i));
                }
                return FloatVector.of(this.field(), values);
            }
            case Boolean: {
                boolean[] values = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsBoolean((Tuple)df.get(i));
                }
                return BooleanVector.of(this.field(), values);
            }
            case Byte: {
                byte[] values = new byte[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsByte((Tuple)df.get(i));
                }
                return ByteVector.of(this.field(), values);
            }
            case Short: {
                short[] values = new short[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsShort((Tuple)df.get(i));
                }
                return ShortVector.of(this.field(), values);
            }
            case Char: {
                char[] values = new char[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsChar((Tuple)df.get(i));
                }
                return CharVector.of(this.field(), values);
            }
        }
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.apply((Tuple)df.get(i));
        }
        return Vector.of(this.field(), values);
    }
}

