/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.io.Serializable;
import smile.data.measure.ContinuousMeasure;
import smile.data.measure.DiscreteMeasure;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;

public class StructField
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final String name;
    public final DataType type;
    public final Measure measure;

    public StructField(String name, DataType type) {
        this(name, type, null);
    }

    public StructField(String name, DataType type, Measure measure) {
        if (measure instanceof ContinuousMeasure && !type.isFloating()) {
            throw new IllegalArgumentException(String.format("%s values cannot be of measure %s", type, measure));
        }
        if (measure instanceof DiscreteMeasure && !type.isIntegral()) {
            throw new IllegalArgumentException(String.format("%s values cannot be of measure %s", type, measure));
        }
        this.name = name;
        this.type = type;
        this.measure = measure;
    }

    public String toString() {
        return this.measure != null ? String.format("%s: %s %s", this.name, this.type, this.measure) : String.format("%s: %s", this.name, this.type);
    }

    public String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return this.measure != null ? this.measure.toString(o) : this.type.toString(o);
    }

    public Object valueOf(String s) {
        return this.measure != null ? this.measure.valueOf(s) : this.type.valueOf(s);
    }

    public boolean isNumeric() {
        if (this.measure instanceof NominalScale) {
            return false;
        }
        return this.type.isFloating() || this.type.isIntegral();
    }

    public boolean equals(Object o) {
        if (o instanceof StructField) {
            StructField f = (StructField)o;
            return this.name.equals(f.name) && this.type.equals(f.type);
        }
        return false;
    }
}

