/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.LongStream;
import smile.data.measure.ContinuousMeasure;
import smile.data.measure.Measure;
import smile.data.type.StructField;
import smile.data.vector.LongVector;

class LongVectorImpl
implements LongVector {
    private String name;
    private Measure measure;
    private long[] vector;

    public LongVectorImpl(String name, long[] vector) {
        this.name = name;
        this.measure = null;
        this.vector = vector;
    }

    public LongVectorImpl(StructField field, long[] vector) {
        if (field.measure instanceof ContinuousMeasure) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<Measure> measure() {
        return Optional.ofNullable(this.measure);
    }

    @Override
    public long[] array() {
        return this.vector;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public Long get(int i) {
        return this.vector[i];
    }

    public LongVector get(int ... index) {
        long[] v = new long[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new LongVectorImpl(this.name, v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public LongStream stream() {
        return Arrays.stream(this.vector);
    }

    public String toString() {
        return this.toString(10);
    }
}

