/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import smile.data.Tuple;
import smile.data.formula.DateFeature;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Date
implements Term {
    private final String name;
    private final DateFeature[] features;

    public Date(String name, DateFeature ... features) {
        this.name = name;
        this.features = features;
    }

    public String toString() {
        return String.format("%s%s", this.name, Arrays.toString((Object[])this.features));
    }

    @Override
    public Set<String> variables() {
        return Collections.singleton(this.name);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        final int index = schema.fieldIndex(this.name);
        final DataType type = schema.field((String)this.name).type;
        switch (type.id()) {
            case Date: {
                if (!this.hasTimeFeatures(this.features)) break;
                throw new UnsupportedOperationException("Cannot extract time features from a date.");
            }
            case Time: {
                if (!this.hasDateFeatures(this.features)) break;
                throw new UnsupportedOperationException("Cannot extract date features from a time.");
            }
            case DateTime: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The filed %s is not a date/time: %s", this.name, type));
            }
        }
        final NominalScale month = new NominalScale(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"});
        final NominalScale dayOfWeek = new NominalScale(new int[]{1, 2, 3, 4, 5, 6, 7}, new String[]{"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"});
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final DateFeature feature : this.features) {
            features.add(new Feature(){
                StructField field;
                {
                    this.field = new StructField(String.format("%s_%s", new Object[]{Date.this.name, feature}), DataTypes.IntegerType, feature == DateFeature.MONTH ? month : (feature == DateFeature.DAY_OF_WEEK ? dayOfWeek : null));
                }

                public String toString() {
                    return this.field.name;
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public int applyAsInt(Tuple o) {
                    Object x = this.apply(o);
                    return x == null ? -1 : (Integer)x;
                }

                @Override
                public Object apply(Tuple o) {
                    Object x = o.get(index);
                    if (x == null) {
                        return null;
                    }
                    switch (type.id()) {
                        case Date: {
                            LocalDate date = (LocalDate)x;
                            switch (feature) {
                                case YEAR: {
                                    return date.getYear();
                                }
                                case MONTH: {
                                    return date.getMonthValue();
                                }
                                case DAY_OF_MONTH: {
                                    return date.getDayOfMonth();
                                }
                                case DAY_OF_WEEK: {
                                    return date.getDayOfWeek().getValue();
                                }
                            }
                            throw new IllegalStateException("Extra time features from a date.");
                        }
                        case Time: {
                            LocalTime time = (LocalTime)x;
                            switch (feature) {
                                case HOURS: {
                                    return time.getHour();
                                }
                                case MINUTES: {
                                    return time.getMinute();
                                }
                                case SECONDS: {
                                    return time.getSecond();
                                }
                            }
                            throw new IllegalStateException("Extra date features from a time.");
                        }
                        case DateTime: {
                            LocalDateTime dateTime = (LocalDateTime)x;
                            switch (feature) {
                                case YEAR: {
                                    return dateTime.getYear();
                                }
                                case MONTH: {
                                    return dateTime.getMonthValue();
                                }
                                case DAY_OF_MONTH: {
                                    return dateTime.getDayOfMonth();
                                }
                                case DAY_OF_WEEK: {
                                    return dateTime.getDayOfWeek().getValue();
                                }
                                case HOURS: {
                                    return dateTime.getHour();
                                }
                                case MINUTES: {
                                    return dateTime.getMinute();
                                }
                                case SECONDS: {
                                    return dateTime.getSecond();
                                }
                            }
                            break;
                        }
                    }
                    throw new IllegalStateException("Unsupported data type for date/time features");
                }
            });
        }
        return features;
    }

    private boolean hasTimeFeatures(DateFeature[] features) {
        for (DateFeature feature : features) {
            switch (feature) {
                case HOURS: 
                case MINUTES: 
                case SECONDS: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasDateFeatures(DateFeature[] features) {
        for (DateFeature feature : features) {
            switch (feature) {
                case YEAR: 
                case MONTH: 
                case DAY_OF_MONTH: 
                case DAY_OF_WEEK: {
                    return true;
                }
            }
        }
        return false;
    }
}

