/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.List;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.type.StructType;

class Round
extends AbstractFunction {
    public Round(Term x) {
        super("round", x);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            DataType type = xfield.type;
            if (!type.isDouble() && !type.isFloat()) {
                throw new IllegalStateException(String.format("Invalid expression: round(%s)", type));
            }
            features.add(new Feature(){
                StructField field;
                {
                    this.field = new StructField(String.format("round(%s)", xfield.name), xfield.type, xfield.measure);
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Object apply(Tuple o) {
                    Object y = feature.apply(o);
                    if (y == null) {
                        return null;
                    }
                    if (y instanceof Double) {
                        return Math.round((Double)y);
                    }
                    if (y instanceof Float) {
                        return Float.valueOf(Math.abs(((Float)y).floatValue()));
                    }
                    throw new IllegalArgumentException("Invalid argument for abs(): " + y);
                }

                @Override
                public float applyAsFloat(Tuple o) {
                    return Math.round(feature.applyAsFloat(o));
                }

                @Override
                public double applyAsDouble(Tuple o) {
                    return Math.round(feature.applyAsDouble(o));
                }
            });
        }
        return features;
    }
}

