/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation2D;
import smile.interpolation.LinearInterpolation;

public class BicubicInterpolation
implements Interpolation2D {
    private static final int[][] wt = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {-3, 0, 0, 3, 0, 0, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, -3, 0, 0, 3, 0, 0, 0, 0, -2, 0, 0, -1}, {0, 0, 0, 0, 2, 0, 0, -2, 0, 0, 0, 0, 1, 0, 0, 1}, {-3, 3, 0, 0, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, -3, 3, 0, 0, -2, -1, 0, 0}, {9, -9, 9, -9, 6, 3, -3, -6, 6, -6, -3, 3, 4, 2, 1, 2}, {-6, 6, -6, 6, -4, -2, 2, 4, -3, 3, 3, -3, -2, -1, -1, -2}, {2, -2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 1, 1, 0, 0}, {-6, 6, -6, 6, -3, -3, 3, 3, -4, 4, 2, -2, -2, -2, -1, -1}, {4, -4, 4, -4, 2, 2, -2, -2, 2, -2, -2, 2, 1, 1, 1, 1}};
    private int m;
    private int n;
    private double[][] yv;
    private double[] x1;
    private double[] x2;
    private LinearInterpolation x1terp;
    private LinearInterpolation x2terp;
    private double[] y = new double[4];
    private double[] y1 = new double[4];
    private double[] y2 = new double[4];
    private double[] y12 = new double[4];

    public BicubicInterpolation(double[] x1, double[] x2, double[][] y) {
        if (x1.length != y.length) {
            throw new IllegalArgumentException("x1.length != y.length");
        }
        if (x2.length != y[0].length) {
            throw new IllegalArgumentException("x2.length != y[0].length");
        }
        this.m = x1.length;
        this.n = x2.length;
        this.x1terp = new LinearInterpolation(x1, x1);
        this.x2terp = new LinearInterpolation(x2, x2);
        this.x1 = x1;
        this.x2 = x2;
        this.yv = y;
    }

    private static double[][] bcucof(double[] y, double[] y1, double[] y2, double[] y12, double d1, double d2) {
        int i;
        double d1d2 = d1 * d2;
        double[] cl = new double[16];
        double[] x = new double[16];
        double[][] c = new double[4][4];
        for (i = 0; i < 4; ++i) {
            x[i] = y[i];
            x[i + 4] = y1[i] * d1;
            x[i + 8] = y2[i] * d2;
            x[i + 12] = y12[i] * d1d2;
        }
        for (i = 0; i < 16; ++i) {
            double xx = 0.0;
            for (int k = 0; k < 16; ++k) {
                xx += (double)wt[i][k] * x[k];
            }
            cl[i] = xx;
        }
        int l = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                c[i][j] = cl[l++];
            }
        }
        return c;
    }

    private static double bcuint(double[] y, double[] y1, double[] y2, double[] y12, double x1l, double x1u, double x2l, double x2u, double x1p, double x2p) {
        if (x1u == x1l) {
            throw new IllegalArgumentException("Nearby control points take same value: " + x1u);
        }
        if (x2u == x2l) {
            throw new IllegalArgumentException("Nearby control points take same value: " + x2u);
        }
        double d1 = x1u - x1l;
        double d2 = x2u - x2l;
        double[][] c = BicubicInterpolation.bcucof(y, y1, y2, y12, d1, d2);
        double t = (x1p - x1l) / d1;
        double u = (x2p - x2l) / d2;
        double ansy = 0.0;
        for (int i = 3; i >= 0; --i) {
            ansy = t * ansy + ((c[i][3] * u + c[i][2]) * u + c[i][1]) * u + c[i][0];
        }
        return ansy;
    }

    @Override
    public double interpolate(double x1p, double x2p) {
        int j = this.x1terp.search(x1p);
        int k = this.x2terp.search(x2p);
        double x1l = this.x1[j];
        double x1u = this.x1[j + 1];
        double x2l = this.x2[k];
        double x2u = this.x2[k + 1];
        this.y[0] = this.yv[j][k];
        this.y[1] = this.yv[j + 1][k];
        this.y[2] = this.yv[j + 1][k + 1];
        this.y[3] = this.yv[j][k + 1];
        this.y1[0] = j - 1 < 0 ? (this.yv[j + 1][k] - this.yv[j][k]) / (this.x1[j + 1] - this.x1[j]) : (this.yv[j + 1][k] - this.yv[j - 1][k]) / (this.x1[j + 1] - this.x1[j - 1]);
        this.y1[1] = j + 2 < this.m ? (this.yv[j + 2][k] - this.yv[j][k]) / (this.x1[j + 2] - this.x1[j]) : (this.yv[j + 1][k] - this.yv[j][k]) / (this.x1[j + 1] - this.x1[j]);
        this.y1[2] = j + 2 < this.m ? (this.yv[j + 2][k + 1] - this.yv[j][k + 1]) / (this.x1[j + 2] - this.x1[j]) : (this.yv[j + 1][k + 1] - this.yv[j][k + 1]) / (this.x1[j + 1] - this.x1[j]);
        this.y1[3] = j - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j][k + 1]) / (this.x1[j + 1] - this.x1[j]) : (this.yv[j + 1][k + 1] - this.yv[j - 1][k + 1]) / (this.x1[j + 1] - this.x1[j - 1]);
        this.y2[0] = k - 1 < 0 ? (this.yv[j][k + 1] - this.yv[j][k]) / (this.x2[k + 1] - this.x2[k]) : (this.yv[j][k + 1] - this.yv[j][k - 1]) / (this.x2[k + 1] - this.x2[k - 1]);
        this.y2[1] = k - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j + 1][k]) / (this.x2[k + 1] - this.x2[k]) : (this.yv[j + 1][k + 1] - this.yv[j + 1][k - 1]) / (this.x2[k + 1] - this.x2[k - 1]);
        this.y2[2] = k + 2 < this.n ? (this.yv[j + 1][k + 2] - this.yv[j + 1][k]) / (this.x2[k + 2] - this.x2[k]) : (this.yv[j + 1][k + 1] - this.yv[j + 1][k]) / (this.x2[k + 1] - this.x2[k]);
        double d = this.y2[3] = k + 2 < this.n ? (this.yv[j][k + 2] - this.yv[j][k]) / (this.x2[k + 2] - this.x2[k]) : (this.yv[j][k + 1] - this.yv[j][k]) / (this.x2[k + 1] - this.x2[k]);
        this.y12[0] = k - 1 < 0 && j - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j + 1][k] - this.yv[j][k + 1] + this.yv[j][k]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 1] - this.x2[k])) : (k - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j + 1][k] - this.yv[j - 1][k + 1] + this.yv[j - 1][k]) / ((this.x1[j + 1] - this.x1[j - 1]) * (this.x2[k + 1] - this.x2[k])) : (j - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j + 1][k - 1] - this.yv[j][k + 1] + this.yv[j][k - 1]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 1] - this.x2[k - 1])) : (this.yv[j + 1][k + 1] - this.yv[j + 1][k - 1] - this.yv[j - 1][k + 1] + this.yv[j - 1][k - 1]) / ((this.x1[j + 1] - this.x1[j - 1]) * (this.x2[k + 1] - this.x2[k - 1]))));
        this.y12[1] = j + 2 < this.m ? (k - 1 < 0 ? (this.yv[j + 2][k + 1] - this.yv[j + 2][k] - this.yv[j][k + 1] + this.yv[j][k]) / ((this.x1[j + 2] - this.x1[j]) * (this.x2[k + 1] - this.x2[k])) : (this.yv[j + 2][k + 1] - this.yv[j + 2][k - 1] - this.yv[j][k + 1] + this.yv[j][k - 1]) / ((this.x1[j + 2] - this.x1[j]) * (this.x2[k + 1] - this.x2[k - 1]))) : (k - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j + 1][k] - this.yv[j][k + 1] + this.yv[j][k]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 1] - this.x2[k])) : (this.yv[j + 1][k + 1] - this.yv[j + 1][k - 1] - this.yv[j][k + 1] + this.yv[j][k - 1]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 1] - this.x2[k - 1])));
        this.y12[2] = j + 2 < this.m && k + 2 < this.n ? (this.yv[j + 2][k + 2] - this.yv[j + 2][k] - this.yv[j][k + 2] + this.yv[j][k]) / ((this.x1[j + 2] - this.x1[j]) * (this.x2[k + 2] - this.x2[k])) : (j + 2 < this.m ? (this.yv[j + 2][k + 1] - this.yv[j + 2][k] - this.yv[j][k + 1] + this.yv[j][k]) / ((this.x1[j + 2] - this.x1[j]) * (this.x2[k + 1] - this.x2[k])) : (k + 2 < this.n ? (this.yv[j + 1][k + 2] - this.yv[j + 1][k] - this.yv[j][k + 2] + this.yv[j][k]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 2] - this.x2[k])) : (this.yv[j + 1][k + 1] - this.yv[j + 1][k] - this.yv[j][k + 1] + this.yv[j][k]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 1] - this.x2[k]))));
        this.y12[3] = k + 2 < this.n ? (j - 1 < 0 ? (this.yv[j + 1][k + 2] - this.yv[j + 1][k] - this.yv[j][k + 2] + this.yv[j][k]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 2] - this.x2[k])) : (this.yv[j + 1][k + 2] - this.yv[j + 1][k] - this.yv[j - 1][k + 2] + this.yv[j - 1][k]) / ((this.x1[j + 1] - this.x1[j - 1]) * (this.x2[k + 2] - this.x2[k]))) : (j - 1 < 0 ? (this.yv[j + 1][k + 1] - this.yv[j + 1][k] - this.yv[j][k + 1] + this.yv[j][k]) / ((this.x1[j + 1] - this.x1[j]) * (this.x2[k + 1] - this.x2[k])) : (this.yv[j + 1][k + 1] - this.yv[j + 1][k] - this.yv[j - 1][k + 1] + this.yv[j - 1][k]) / ((this.x1[j + 1] - this.x1[j - 1]) * (this.x2[k + 1] - this.x2[k])));
        return BicubicInterpolation.bcuint(this.y, this.y1, this.y2, this.y12, x1l, x1u, x2l, x2u, x1p, x2p);
    }

    public String toString() {
        return "BiCubic Interpolation";
    }
}

