/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation.variogram;

import smile.interpolation.variogram.Variogram;
import smile.math.MathEx;

public class PowerVariogram
implements Variogram {
    private double alpha;
    private double beta;
    private double nugget;

    public PowerVariogram(double[][] x, double[] y) {
        this(x, y, 1.5);
    }

    public PowerVariogram(double[][] x, double[] y, double beta) {
        this(x, y, beta, 0.0);
    }

    public PowerVariogram(double[][] x, double[] y, double beta, double nugget) {
        if (beta < 1.0 || beta >= 2.0) {
            throw new IllegalArgumentException("Invalid beta = " + beta);
        }
        if (nugget < 0.0) {
            throw new IllegalArgumentException("Invalid nugget effect = " + nugget);
        }
        this.beta = beta;
        this.nugget = nugget;
        int n = x.length;
        int dim = x[0].length;
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double rb = 0.0;
                for (int k = 0; k < dim; ++k) {
                    rb += MathEx.sqr((double)(x[i][k] - x[j][k]));
                }
                rb = Math.pow(rb, 0.5 * beta);
                num += rb * 0.5 * MathEx.sqr((double)(y[i] - y[j] - nugget));
                denom += rb * rb;
            }
        }
        this.alpha = num / denom;
    }

    public double f(double r) {
        return this.nugget + this.alpha * Math.pow(r, this.beta);
    }

    public String toString() {
        return String.format("Power Variogram(range = %.4f, sill = %.4f, nugget effect = %.4f)", this.alpha, this.beta, this.nugget);
    }
}

