/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Arff
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Arff.class);
    private static final String ARFF_RELATION = "@relation";
    private static final String ARFF_DATA = "@data";
    private static final String ARFF_ATTRIBUTE = "@attribute";
    private static final String ARFF_ATTRIBUTE_INTEGER = "integer";
    private static final String ARFF_ATTRIBUTE_REAL = "real";
    private static final String ARFF_ATTRIBUTE_NUMERIC = "numeric";
    private static final String ARFF_ATTRIBUTE_STRING = "string";
    private static final String ARFF_ATTRIBUTE_DATE = "date";
    private static final String ARFF_ATTRIBUTE_RELATIONAL = "relational";
    private static final String ARFF_END_SUBRELATION = "@end";
    private static final String PREMATURE_END_OF_FILE = "premature end of file";
    private Reader reader;
    private StreamTokenizer tokenizer;
    private String name;
    private StructType schema;
    private List<Function<String, Object>> parser;
    private String path = "";

    public Arff(Path path) throws IOException, ParseException {
        this.reader = Files.newBufferedReader(path);
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(33, 255);
        this.tokenizer.whitespaceChars(44, 44);
        this.tokenizer.commentChar(37);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.ordinaryChar(123);
        this.tokenizer.ordinaryChar(125);
        this.tokenizer.eolIsSignificant(true);
        this.readHeader();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String name() {
        return this.name;
    }

    public StructType schema() {
        return this.schema;
    }

    private void getFirstToken() throws IOException {
        while (this.tokenizer.nextToken() == 10) {
        }
        if (this.tokenizer.ttype == 39 || this.tokenizer.ttype == 34) {
            this.tokenizer.ttype = -3;
        } else if (this.tokenizer.ttype == -3 && this.tokenizer.sval.equals("?")) {
            this.tokenizer.ttype = 63;
        }
    }

    private void getLastToken(boolean endOfFileOk) throws IOException, ParseException {
        if (!(this.tokenizer.nextToken() == 10 || this.tokenizer.ttype == -1 && endOfFileOk)) {
            throw new ParseException("end of line expected", this.tokenizer.lineno());
        }
    }

    private void getNextToken() throws IOException, ParseException {
        if (this.tokenizer.nextToken() == 10) {
            throw new ParseException("premature end of line", this.tokenizer.lineno());
        }
        if (this.tokenizer.ttype == -1) {
            throw new ParseException(PREMATURE_END_OF_FILE, this.tokenizer.lineno());
        }
        if (this.tokenizer.ttype == 39 || this.tokenizer.ttype == 34) {
            this.tokenizer.ttype = -3;
        } else if (this.tokenizer.ttype == -3 && this.tokenizer.sval.equals("?")) {
            this.tokenizer.ttype = 63;
        }
    }

    private void readHeader() throws IOException, ParseException {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            throw new ParseException(PREMATURE_END_OF_FILE, this.tokenizer.lineno());
        }
        if (!ARFF_RELATION.equalsIgnoreCase(this.tokenizer.sval)) {
            throw new ParseException("keyword @relation expected", this.tokenizer.lineno());
        }
        this.getNextToken();
        this.name = this.tokenizer.sval;
        logger.info("Read ARFF relation {}", (Object)this.name);
        this.getLastToken(false);
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            throw new ParseException(PREMATURE_END_OF_FILE, this.tokenizer.lineno());
        }
        while (ARFF_ATTRIBUTE.equalsIgnoreCase(this.tokenizer.sval)) {
            StructField attribute = this.nextAttribute();
            if (attribute == null) continue;
            fields.add(attribute);
        }
        if (!ARFF_DATA.equalsIgnoreCase(this.tokenizer.sval)) {
            throw new ParseException("keyword @data expected", this.tokenizer.lineno());
        }
        if (fields.isEmpty()) {
            throw new ParseException("no attributes declared", this.tokenizer.lineno());
        }
        this.schema = DataTypes.struct(fields);
        this.parser = this.schema.parser();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StructField nextAttribute() throws IOException, ParseException {
        StructField attribute = null;
        this.getNextToken();
        String name = this.attributeName(this.tokenizer.sval);
        this.getNextToken();
        if (this.tokenizer.ttype == -3) {
            if (this.tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_NUMERIC)) {
                attribute = new StructField(name, (DataType)DataTypes.DoubleType);
                this.readTillEOL();
            } else if (this.tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_REAL)) {
                attribute = new StructField(name, (DataType)DataTypes.FloatType);
                this.readTillEOL();
            } else if (this.tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_INTEGER)) {
                attribute = new StructField(name, (DataType)DataTypes.IntegerType);
                this.readTillEOL();
            } else if (this.tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_STRING)) {
                attribute = new StructField(name, (DataType)DataTypes.StringType);
                this.readTillEOL();
            } else if (this.tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_DATE)) {
                if (this.tokenizer.nextToken() != 10) {
                    if (this.tokenizer.ttype != -3 && this.tokenizer.ttype != 39 && this.tokenizer.ttype != 34) {
                        throw new ParseException("not a valid date format", this.tokenizer.lineno());
                    }
                    attribute = new StructField(name, (DataType)DataTypes.datetime((String)this.tokenizer.sval));
                    this.readTillEOL();
                } else {
                    attribute = new StructField(name, (DataType)DataTypes.DateTimeType);
                    this.tokenizer.pushBack();
                }
                this.readTillEOL();
            } else if (this.tokenizer.sval.equalsIgnoreCase(ARFF_ATTRIBUTE_RELATIONAL)) {
                logger.info("Encounter relational attribute {}. Flat out its attributes to top level.", (Object)name);
                this.path = this.path + "." + name;
                this.readTillEOL();
            } else {
                if (!this.tokenizer.sval.equalsIgnoreCase(ARFF_END_SUBRELATION)) throw new ParseException("Invalid attribute type or invalid enumeration", this.tokenizer.lineno());
                this.path = this.path.substring(0, this.path.lastIndexOf(46));
                this.getNextToken();
            }
        } else {
            ArrayList<String> attributeValues = new ArrayList<String>();
            this.tokenizer.pushBack();
            if (this.tokenizer.nextToken() != 123) {
                throw new ParseException("{ expected at beginning of enumeration", this.tokenizer.lineno());
            }
            while (this.tokenizer.nextToken() != 125) {
                if (this.tokenizer.ttype == 10) {
                    throw new ParseException("} expected at end of enumeration", this.tokenizer.lineno());
                }
                attributeValues.add(this.tokenizer.sval.trim());
            }
            NominalScale scale = new NominalScale(attributeValues);
            attribute = new StructField(name, scale.type(), Optional.of(scale));
        }
        this.getLastToken(false);
        this.getFirstToken();
        if (this.tokenizer.ttype != -1) return attribute;
        throw new ParseException(PREMATURE_END_OF_FILE, this.tokenizer.lineno());
    }

    private String attributeName(String name) {
        return this.path.length() == 0 ? name : this.path + "." + name;
    }

    private void readTillEOL() throws IOException {
        while (this.tokenizer.nextToken() != 10) {
        }
        this.tokenizer.pushBack();
    }

    public DataFrame read() throws IOException, ParseException {
        return this.read(Integer.MAX_VALUE);
    }

    public DataFrame read(int limit) throws IOException, ParseException {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid limit: " + limit);
        }
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        for (int i = 0; i < limit; ++i) {
            this.getFirstToken();
            if (this.tokenizer.ttype == -1) break;
            Object[] row = this.tokenizer.ttype == 123 ? this.readSparseInstance() : this.readInstance();
            rows.add(Tuple.of((Object[])row, (StructType)this.schema));
        }
        this.schema = this.schema.boxed(rows);
        return DataFrame.of(rows, (StructType)this.schema);
    }

    private Object[] readInstance() throws IOException, ParseException {
        StructField[] fields = this.schema.fields();
        int p = fields.length;
        Object[] x = new Object[p];
        for (int i = 0; i < p; ++i) {
            if (i > 0) {
                this.getNextToken();
            }
            if (this.tokenizer.ttype == 63) continue;
            x[i] = this.parser.get(i).apply(this.tokenizer.sval);
        }
        return x;
    }

    private Object[] readSparseInstance() throws IOException, ParseException {
        int i;
        StructField[] fields = this.schema.fields();
        int p = fields.length;
        Object[] x = new Object[p];
        do {
            this.getNextToken();
            if (this.tokenizer.ttype == 125) break;
            i = Integer.parseInt(this.tokenizer.sval.trim());
            if (i < 0 || i >= p) {
                throw new ParseException("Invalid attribute index: " + i, this.tokenizer.lineno());
            }
            this.getNextToken();
            String val = this.tokenizer.sval.trim();
            if (val.equals("?")) continue;
            x[i] = this.parser.get(i).apply(val);
        } while (this.tokenizer.ttype == -3);
        for (i = 0; i < x.length; ++i) {
            if (x[i] != null) continue;
            StructField field = this.schema.field(i);
            x[i] = field.type.isByte() ? (Number)((byte)0) : (Number)(field.type.isShort() ? (Number)((short)0) : (Number)(field.type.isInt() ? (Number)0 : (Number)(field.type.isFloat() ? (Number)Float.valueOf(0.0f) : (Number)0.0)));
        }
        return x;
    }

    public static void write(DataFrame df, Path path, String relation) throws IOException {
        try (PrintWriter writer = new PrintWriter(Files.newOutputStream(path, new OpenOption[0]));){
            writer.print("@RELATION ");
            writer.println(relation);
            for (StructField field : df.schema().fields()) {
                Arff.writeField(writer, field);
            }
            writer.println("@DATA");
            int p = df.ncols();
            df.stream().forEach(t -> {
                String line = IntStream.range(0, p).mapToObj(i -> t.toString()).collect(Collectors.joining(","));
                writer.println(line);
            });
        }
    }

    private static void writeField(PrintWriter writer, StructField field) throws IOException {
        writer.print("@ATTRIBUTE ");
        writer.print(field.name);
        if (field.type.isFloating()) {
            writer.println(" REAL");
        } else if (field.type.isString()) {
            writer.println(" STRING");
        } else if (field.type.id() == DataType.ID.DateTime) {
            writer.println(" DATE \"yyyy-MM-dd HH:mm:ss\"");
        } else if (field.type.isIntegral()) {
            Optional measure = field.measure;
            if (measure.isPresent() && measure.get() instanceof NominalScale) {
                NominalScale scale = (NominalScale)measure.get();
                String levels = Arrays.stream(scale.levels()).collect(Collectors.joining(",", " {", "}"));
                writer.println(levels);
            } else {
                writer.println(" REAL");
            }
        }
    }
}

