/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.commons.csv.CSVFormat;
import smile.data.DataFrame;
import smile.data.Dataset;
import smile.data.Instance;
import smile.data.type.StructType;
import smile.io.Arff;
import smile.io.Arrow;
import smile.io.Avro;
import smile.io.CSV;
import smile.io.JSON;
import smile.io.Parquet;
import smile.io.SAS;
import smile.util.SparseArray;

public interface DatasetReader {
    public static DataFrame csv(Path path) throws IOException {
        return DatasetReader.csv(path, CSVFormat.DEFAULT);
    }

    public static DataFrame csv(Path path, CSVFormat format) throws IOException {
        return DatasetReader.csv(path, format, null);
    }

    public static DataFrame csv(Path path, CSVFormat format, StructType schema) throws IOException {
        CSV csv = new CSV(format);
        if (schema != null) {
            csv.schema(schema);
        }
        return csv.read(path);
    }

    public static DataFrame json(Path path) throws IOException {
        return DatasetReader.json(path, JSON.Mode.SINGLE_LINE, null);
    }

    public static DataFrame json(Path path, JSON.Mode mode, StructType schema) throws IOException {
        JSON json = new JSON().mode(mode);
        if (schema != null) {
            json.schema(schema);
        }
        return json.read(path);
    }

    public static DataFrame arff(Path path) throws IOException, ParseException {
        Arff arff = new Arff(path);
        return arff.read();
    }

    public static DataFrame sas(Path path) throws IOException {
        return SAS.read(path);
    }

    public static DataFrame arrow(Path path) throws IOException {
        Arrow arrow = new Arrow();
        return arrow.read(path);
    }

    public static DataFrame avro(Path path, Schema schema) throws IOException {
        Avro avro = new Avro(schema);
        return avro.read(path);
    }

    public static DataFrame parquet(Path path) throws IOException {
        return Parquet.read(path);
    }

    public static Dataset<Instance<SparseArray>> libsvm(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line = reader.readLine();
            if (line == null) {
                throw new IOException("Empty data source.");
            }
            String token = line.trim().split("\\s+")[0];
            boolean classification = true;
            try {
                Integer.valueOf(token);
            }
            catch (NumberFormatException e) {
                try {
                    Double.valueOf(token);
                    classification = false;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("Unrecognized response variable value: " + token);
                }
            }
            ArrayList<Object> data = new ArrayList<Object>();
            do {
                String[] tokens = line.trim().split("\\s+");
                final String firstToken = tokens[0];
                final SparseArray row = new SparseArray();
                for (int k = 1; k < tokens.length; ++k) {
                    String[] pair = tokens[k].split(":");
                    if (pair.length != 2) {
                        throw new NumberFormatException("Invalid token: " + tokens[k]);
                    }
                    int j = Integer.parseInt(pair[0]) - 1;
                    double x = Double.parseDouble(pair[1]);
                    row.set(j, x);
                }
                if (classification) {
                    data.add(new Instance<SparseArray>(){
                        int y;
                        {
                            this.y = Integer.parseInt(firstToken);
                        }

                        public SparseArray x() {
                            return row;
                        }

                        public int label() {
                            return this.y;
                        }
                    });
                    continue;
                }
                data.add(new Instance<SparseArray>(){
                    double y;
                    {
                        this.y = Double.parseDouble(firstToken);
                    }

                    public SparseArray x() {
                        return row;
                    }

                    public double y() {
                        return this.y;
                    }
                });
            } while ((line = reader.readLine()) != null);
            Dataset dataset = Dataset.of(data);
            return dataset;
        }
    }
}

