/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.util.Strings;

public class JSON {
    private StructType schema;
    private Charset charset = StandardCharsets.UTF_8;
    private Mode mode = Mode.SINGLE_LINE;

    public JSON schema(StructType schema) {
        this.schema = schema;
        return this;
    }

    public JSON charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JSON mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public DataFrame read(Path path) throws IOException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(Path path, int limit) throws IOException {
        if (this.schema == null) {
            this.schema = this.inferSchema(path, Math.min(1000, limit));
        }
        List parser = this.schema.parser();
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        ObjectMapper objectMapper = new ObjectMapper();
        if (this.mode == Mode.MULTI_LINE) {
            List maps = (List)objectMapper.readValue((Reader)Files.newBufferedReader(path), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
            for (Map map : maps) {
                rows.add(this.toTuple(map, parser));
                if (rows.size() < limit) continue;
                break;
            }
        } else {
            Files.lines(path, this.charset).limit(limit).forEach(line -> {
                try {
                    Map map = (Map)objectMapper.readValue(line, (TypeReference)new TypeReference<Map<String, String>>(){});
                    rows.add(this.toTuple(map, parser));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        this.schema = this.schema.boxed(rows);
        return DataFrame.of(rows, (StructType)this.schema);
    }

    private Tuple toTuple(Map<String, String> map, List<Function<String, Object>> parser) {
        Object[] row = new Object[this.schema.length()];
        for (int i = 0; i < row.length; ++i) {
            String s = map.get(this.schema.field((int)i).name);
            if (Strings.isNullOrEmpty((String)s)) continue;
            row[i] = parser.get(i).apply(s);
        }
        return Tuple.of((Object[])row, (StructType)this.schema);
    }

    public StructType inferSchema(Path path, int limit) throws IOException {
        ArrayList<Map> rows = new ArrayList<Map>();
        ObjectMapper objectMapper = new ObjectMapper();
        if (this.mode == Mode.MULTI_LINE) {
            List maps = (List)objectMapper.readValue((Reader)Files.newBufferedReader(path), (TypeReference)new TypeReference<List<Map<String, String>>>(){});
            for (Map map : maps) {
                rows.add(map);
                if (rows.size() < limit) continue;
                break;
            }
        } else {
            Files.lines(path, this.charset).limit(limit).forEach(line -> {
                try {
                    Map map = (Map)objectMapper.readValue(line, (TypeReference)new TypeReference<Map<String, String>>(){});
                    rows.add(map);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        if (rows.isEmpty()) {
            throw new IOException("Empty file");
        }
        HashMap<String, DataType> types = new HashMap<String, DataType>();
        for (Map row : rows) {
            for (Map.Entry e : row.entrySet()) {
                String name = (String)e.getKey();
                String value = (String)e.getValue();
                types.put(name, DataType.coerce((DataType)((DataType)types.get(name)), (DataType)DataType.infer((String)value)));
            }
        }
        int i = 0;
        StructField[] fields = new StructField[types.size()];
        for (Map.Entry type : types.entrySet()) {
            fields[i++] = new StructField((String)type.getKey(), (DataType)type.getValue());
        }
        return DataTypes.struct((StructField[])fields);
    }

    public static enum Mode {
        SINGLE_LINE,
        MULTI_LINE;

    }
}

