/*
 * Decompiled with CFR 0.152.
 */
package smile.json;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import smile.json.JsArray;
import smile.json.JsArray$;
import smile.json.JsCounter;
import smile.json.JsDouble;
import smile.json.JsDouble$;
import smile.json.JsInt;
import smile.json.JsInt$;
import smile.json.JsLong;
import smile.json.JsNull$;
import smile.json.JsObject;
import smile.json.JsObject$;
import smile.json.JsObjectId$;
import smile.json.JsString;
import smile.json.JsString$;
import smile.json.JsUUID$;
import smile.json.JsValue;
import smile.json.JsonParser$;
import smile.json.ParserInput;
import smile.json.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=w!\u0002\u001b6\u0011\u0003Qd!\u0002\u001f6\u0011\u0003i\u0004\"\u0002#\u0002\t\u0003)\u0005\"\u0002$\u0002\t\u00039e\u0001\u0002)\u0002\u0001EC\u0001B\u0018\u0003\u0003\u0006\u0004%\ta\u0018\u0005\tQ\u0012\u0011\t\u0011)A\u0005A\"A\u0011\u000e\u0002BC\u0002\u0013\u0005q\f\u0003\u0005k\t\t\u0005\t\u0015!\u0003a\u0011\u0015!E\u0001\"\u0001l\u000f\u001d\u0001\u0018!!A\t\u0002E4q\u0001U\u0001\u0002\u0002#\u0005!\u000fC\u0003E\u0017\u0011\u0005a\u000fC\u0004x\u0017E\u0005I\u0011\u0001=\t\u0013\u0005\u001d1\"!A\u0005\n\u0005%a!\u0002\u001f6\u0001\u0005m\u0001\u0002\u0003'\u0010\u0005\u0003\u0005\u000b\u0011B'\t\r\u0011{A\u0011AA\u000f\u0011!\t\u0019c\u0004Q\u0001\n\u0005\u0015\u0002\u0002CA\u0016\u001f\u0001\u0006K!!\f\t\u0015\u0005Mr\u00021A\u0001B\u0003&\u0001\nC\u0004\u00026=!\t!a\u000e\t\u0013\u0005erB1A\u0005\u000e\u0005m\u0002\u0002CA!\u001f\u0001\u0006i!!\u0010\t\u000f\u0005\rs\u0002\"\u0003\u0002F!9\u0011QJ\b\u0005\n\u0005=\u0003bBA,\u001f\u0011%\u0011q\n\u0005\b\u00033zA\u0011BA(\u0011\u001d\tYf\u0004C\u0005\u0003;Bq!a\u0019\u0010\t\u0013\t)\u0005C\u0004\u0002f=!I!!\u0012\t\u000f\u0005\u001dt\u0002\"\u0003\u0002F!9\u0011\u0011N\b\u0005\n\u0005\u0015\u0003bBA6\u001f\u0011%\u0011q\n\u0005\b\u0003[zA\u0011BA(\u0011\u001d\tyg\u0004C\u0005\u0003\u001fBq!!\u001d\u0010\t\u0013\ty\u0005C\u0004\u0002t=!I!!\u0012\t\u000f\u0005Ut\u0002\"\u0003\u0002F!9\u0011\u0011Q\b\u0005\n\u0005=\u0003bBAB\u001f\u0011%\u0011Q\t\u0005\b\u0003\u000b{A\u0011BA(\u0011\u001d\t9i\u0004C\u0005\u0003\u001fBq!!#\u0010\t\u0013\t)\u0005C\u0004\u0002\u000e>!I!a$\t\u000f\u0005%u\u0002\"\u0003\u0002\u0016\"9\u0011\u0011T\b\u0005\n\u0005=\u0003bBAN\u001f\u0011%\u0011Q\u0014\u0005\b\u0003C{A\u0011BAR\u0011\u001d\t9k\u0004C\u0005\u0003SC\u0011\"a1\u0010#\u0003%I!!2\t\u0013\u0005%w\"%A\u0005\n\u0005-\u0017A\u0003&t_:\u0004\u0016M]:fe*\u0011agN\u0001\u0005UN|gNC\u00019\u0003\u0015\u0019X.\u001b7f\u0007\u0001\u0001\"aO\u0001\u000e\u0003U\u0012!BS:p]B\u000b'o]3s'\t\ta\b\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\nQ!\u00199qYf$\"\u0001S&\u0011\u0005mJ\u0015B\u0001&6\u0005\u001dQ5OV1mk\u0016DQ\u0001T\u0002A\u00025\u000bQ!\u001b8qkR\u0004\"a\u000f(\n\u0005=+$a\u0003)beN,'/\u00138qkR\u0014\u0001\u0003U1sg&tw-\u0012=dKB$\u0018n\u001c8\u0014\u0005\u0011\u0011\u0006CA*\\\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002Xs\u00051AH]8pizJ\u0011!Q\u0005\u00035\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0002];\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u00035\u0002\u000bqa];n[\u0006\u0014\u00180F\u0001a!\t\tWM\u0004\u0002cGB\u0011Q\u000bQ\u0005\u0003I\u0002\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A\rQ\u0001\tgVlW.\u0019:zA\u00051A-\u001a;bS2\fq\u0001Z3uC&d\u0007\u0005F\u0002m]>\u0004\"!\u001c\u0003\u000e\u0003\u0005AQAX\u0005A\u0002\u0001Dq![\u0005\u0011\u0002\u0003\u0007\u0001-\u0001\tQCJ\u001c\u0018N\\4Fq\u000e,\u0007\u000f^5p]B\u0011QnC\n\u0004\u0017y\u001a\bCA u\u0013\t)\bI\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001r\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0011P\u000b\u0002au.\n1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0001)\u0001\u0006b]:|G/\u0019;j_:L1!!\u0002~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001\u00027b]\u001eT!!!\u0006\u0002\t)\fg/Y\u0005\u0005\u00033\tyA\u0001\u0004PE*,7\r^\n\u0003\u001fy\"B!a\b\u0002\"A\u00111h\u0004\u0005\u0006\u0019F\u0001\r!T\u0001\u0003g\n\u0004B!!\u0004\u0002(%!\u0011\u0011FA\b\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\u0006Q1-\u001e:t_J\u001c\u0005.\u0019:\u0011\u0007}\ny#C\u0002\u00022\u0001\u0013Aa\u00115be\u00069!n\u001d,bYV,\u0017\u0001\u00049beN,'j\u001d,bYV,G#\u0001%\u0002\u0007\u0015{\u0015*\u0006\u0002\u0002>=\u0011\u0011q\b\u000f\u0004\u0001}\u0000 \u0001B#P\u0013\u0002\nQA^1mk\u0016$\"!a\u0012\u0011\u0007}\nI%C\u0002\u0002L\u0001\u0013A!\u00168ji\u0006)a-\u00197tKR\u0011\u0011\u0011\u000b\t\u0004\u007f\u0005M\u0013bAA+\u0001\n9!i\\8mK\u0006t\u0017\u0001\u00028vY2\fA\u0001\u001e:vK\u0006Y\u0001/\u0019:tKN#(/\u001b8h)\rA\u0015q\f\u0005\u0007\u0003Cb\u0002\u0019\u00011\u0002\u0003M\faa\u001c2kK\u000e$\u0018!B1se\u0006L\u0018A\u00028v[\n,'/A\u0002j]R\fAA\u001a:bG\u0006\u0019Q\r\u001f9\u0002\t1|gnZ\u0001\bG>,h\u000e^3s\u0003=yg.Z(s\u001b>\u0014X\rR5hSR\u001c\u0018\u0001\u0005>fe>|%/T8sK\u0012Kw-\u001b;tQ\r1\u0013\u0011\u0010\t\u0005\u0003w\ni(D\u0001\u0000\u0013\r\tyh \u0002\bi\u0006LGN]3d\u0003\u0015!\u0015jR%U\u0003\u0019\u0019HO]5oO\u0006!1\r[1s\u0003\u001d)7oY1qK\u0012\f!a^:)\u0007-\nI(\u0001\u0002dQR!\u0011\u0011KAI\u0011\u001d\t\u0019\n\fa\u0001\u0003[\t\u0011a\u0019\u000b\u0005\u0003#\n9\nC\u0004\u0002\u00146\u0002\r!!\f\u0002\u000f\u0005$g/\u00198dK\u0006A\u0011\r\u001d9f]\u0012\u001c&\t\u0006\u0003\u0002R\u0005}\u0005bBAJ_\u0001\u0007\u0011QF\u0001\be\u0016\fX/\u001b:f)\u0011\t9%!*\t\u000f\u0005M\u0005\u00071\u0001\u0002.\u0005!a-Y5m)!\tY+!-\u00026\u0006}\u0006cA \u0002.&\u0019\u0011q\u0016!\u0003\u000f9{G\u000f[5oO\"1\u00111W\u0019A\u0002\u0001\fa\u0001^1sO\u0016$\b\"CA\\cA\u0005\t\u0019AA]\u0003\u0019\u0019WO]:peB\u0019q(a/\n\u0007\u0005u\u0006IA\u0002J]RD\u0011\"!12!\u0003\u0005\r!!\f\u0002\u0013\u0015\u0014(o\u001c:DQ\u0006\u0014\u0018A\u00044bS2$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fT3!!/{\u000391\u0017-\u001b7%I\u00164\u0017-\u001e7uIM*\"!!4+\u0007\u00055\"\u0010")
public class JsonParser {
    private final ParserInput input;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public JsValue parseJsValue() {
        this.ws();
        this.value();
        this.require('\uffff');
        return this.jsValue;
    }

    private final char EOI() {
        return '\uffff';
    }

    private void value() {
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            case 'f': {
                this.simpleValue$1(this.false(), package$.MODULE$.JsFalse(), mark);
                break;
            }
            case 'n': {
                this.simpleValue$1(this.null(), JsNull$.MODULE$, mark);
                break;
            }
            case 't': {
                this.simpleValue$1(this.true(), package$.MODULE$.JsTrue(), mark);
                break;
            }
            case '{': {
                this.advance();
                this.object();
                break;
            }
            case '[': {
                this.advance();
                this.array();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                break;
            }
            case '\"': {
                this.string();
                this.jsValue = this.sb.length() == 0 ? JsString$.MODULE$.empty() : this.parseString(this.sb.toString());
                break;
            }
            default: {
                throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private JsValue parseString(String s) {
        return s.length() == JsObjectId$.MODULE$.formatLength() && JsObjectId$.MODULE$.regex().pattern().matcher(s).matches() ? JsObjectId$.MODULE$.apply(s.substring(9, 33)) : (s.length() == JsUUID$.MODULE$.formatLength() && JsUUID$.MODULE$.regex().pattern().matcher(s).matches() ? JsUUID$.MODULE$.apply(s) : new JsString(s));
    }

    private void object() {
        JsObject jsObject;
        this.ws();
        if (this.cursorChar != '}') {
            Map map = Predef$.MODULE$.Map().empty();
            map = this.members$1(map);
            this.require('}');
            jsObject = JsObject$.MODULE$.apply((Map<String, JsValue>)map);
        } else {
            this.advance();
            jsObject = JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)Nil$.MODULE$);
        }
        this.jsValue = jsObject;
        this.ws();
    }

    private void array() {
        JsArray jsArray;
        this.ws();
        if (this.cursorChar != ']') {
            Builder list = scala.package$.MODULE$.Vector().newBuilder();
            this.values$1(list);
            this.require(']');
            jsArray = JsArray$.MODULE$.apply((Seq<JsValue>)((Seq)list.result()));
        } else {
            this.advance();
            jsArray = JsArray$.MODULE$.apply((Seq<JsValue>)Nil$.MODULE$);
        }
        this.jsValue = jsArray;
        this.ws();
    }

    private void number() {
        JsValue jsValue;
        int start = this.input.cursor();
        char startChar = this.cursorChar;
        this.ch('-');
        this.int();
        boolean hasFrac = this.frac();
        boolean hasExp = this.exp();
        boolean hasLong = this.long();
        boolean hasCounter = this.counter();
        if (startChar == '0' && this.input.cursor() - start == 1) {
            jsValue = JsInt$.MODULE$.zero();
        } else {
            String s = String.valueOf(this.input.sliceCharArray(start, this.input.cursor()));
            if (hasFrac || hasExp) {
                double n = new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
                double d = n;
                JsDouble jsDouble = 0.0 == d ? JsDouble$.MODULE$.zero() : (1.0 == d ? JsDouble$.MODULE$.one() : new JsDouble(n));
                jsValue = jsDouble;
            } else {
                jsValue = hasLong ? new JsLong(new StringOps(Predef$.MODULE$.augmentString(s.substring(0, s.length() - 1))).toLong()) : (hasCounter ? new JsCounter(new StringOps(Predef$.MODULE$.augmentString(s.substring(0, s.length() - 1))).toLong()) : JsonParser.liftedTree1$1(s));
            }
        }
        this.jsValue = jsValue;
        this.ws();
    }

    private void int() {
        block0: {
            if (this.ch('0')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private boolean frac() {
        boolean bl;
        if (this.ch('.')) {
            this.oneOrMoreDigits();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean exp() {
        boolean bl;
        if (this.ch('e') || this.ch('E')) {
            boolean bl2 = this.ch('-') || this.ch('+');
            this.oneOrMoreDigits();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean long() {
        return this.ch('l') || this.ch('L');
    }

    private boolean counter() {
        return this.ch('c') || this.ch('C');
    }

    private void oneOrMoreDigits() {
        if (!this.DIGIT()) {
            throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
        }
        this.zeroOrMoreDigits();
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        if (this.cursorChar != '\"') {
            throw this.fail("'\"'", this.fail$default$2(), this.fail$default$3());
        }
        this.cursorChar = this.input.nextUtf8Char();
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        boolean bl;
        if ((1L << this.cursorChar & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = this.appendSB(this.cursorChar);
        } else {
            char c = this.cursorChar;
            switch (c) {
                case '\"': 
                case '\uffff': {
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.escaped();
                    break;
                }
                default: {
                    if (c >= ' ' && this.appendSB(c)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean escaped() {
        boolean bl;
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                bl = this.appendSB(this.cursorChar);
                break;
            }
            case 'b': {
                bl = this.appendSB('\b');
                break;
            }
            case 'f': {
                bl = this.appendSB('\f');
                break;
            }
            case 'n': {
                bl = this.appendSB('\n');
                break;
            }
            case 'r': {
                bl = this.appendSB('\r');
                break;
            }
            case 't': {
                bl = this.appendSB('\t');
                break;
            }
            case 'u': {
                this.advance();
                bl = this.unicode$1();
                break;
            }
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail(new StringBuilder(2).append("'").append(c).append("'").toString(), this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        String string;
        ParserInput.Line line = this.input.getLine(cursor);
        if (line == null) {
            throw new MatchError((Object)line);
        }
        int lineNr = line.lineNr();
        int col = line.column();
        String text = line.text();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)col), (Object)text);
        Tuple3 tuple32 = tuple3;
        int lineNr2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int col2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        String text2 = (String)tuple32._3();
        if (errorChar != '\uffff') {
            String c2 = Character.isISOControl(errorChar) ? new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorChar)})) : ((Object)BoxesRunTime.boxToCharacter((char)errorChar)).toString();
            string = new StringBuilder(12).append("character '").append(c2).append("'").toString();
        } else {
            string = "end-of-input";
        }
        String unexpected = string;
        String string2 = target;
        String string3 = "'\uffff'";
        String expected = (string2 == null ? string3 != null : !string2.equals(string3)) ? target : "end-of-input";
        String summary = new StringBuilder(57).append("Unexpected ").append(unexpected).append(" at input index ").append(cursor).append(" (line ").append(lineNr2).append(", position ").append(col2).append("), expected ").append(expected).toString();
        String sanitizedText = (String)new StringOps(Predef$.MODULE$.augmentString(text2)).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)JsonParser.$anonfun$fail$1(BoxesRunTime.unboxToChar((Object)c))), Predef$.MODULE$.StringCanBuildFrom());
        String detail = new StringBuilder(4).append("\n").append(sanitizedText).append("\n").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(col2 - 1)).append("^\n").toString();
        throw new ParsingException(summary, detail);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(boolean matched, JsValue value, int mark$1) {
        if (!matched) {
            throw this.fail("JSON Value", mark$1, this.fail$default$3());
        }
        this.jsValue = value;
    }

    private final Map members$1(Map map) {
        Map nextMap;
        while (true) {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value();
            nextMap = map.updated((Object)key, (Object)this.jsValue);
            if (!this.ws(',')) break;
            map = nextMap;
        }
        return nextMap;
    }

    private final void values$1(Builder list$1) {
        do {
            this.value();
            list$1.$plus$eq((Object)this.jsValue);
        } while (this.ws(','));
    }

    private static final JsValue liftedTree1$1(String s$1) {
        Ordered<JsLong> ordered;
        try {
            int n;
            int n2 = n = new StringOps(Predef$.MODULE$.augmentString(s$1)).toInt();
            switch (n2) {
                case 0: {
                    ordered = JsInt$.MODULE$.zero();
                    break;
                }
                case 1: {
                    ordered = JsInt$.MODULE$.one();
                    break;
                }
                default: {
                    ordered = new JsInt(n);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            ordered = new JsLong(new StringOps(Predef$.MODULE$.augmentString(s$1)).toLong());
        }
        return ordered;
    }

    private final int hexValue$1(char c) {
        int n;
        if ('0' <= c && c <= '9') {
            n = c - 48;
        } else if ('a' <= c && c <= 'f') {
            n = c - 87;
        } else if ('A' <= c && c <= 'F') {
            n = c - 55;
        } else {
            throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
        }
        return n;
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    public static final /* synthetic */ char $anonfun$fail$1(char c) {
        return Character.isISOControl(c) ? (char)'?' : (char)c;
    }

    public JsonParser(ParserInput input) {
        this.input = input;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : new StringBuilder(1).append(summary).append(":").append(detail).toString()));
        }
    }
}

