/*
 * Decompiled with CFR 0.152.
 */
package smile.json;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;
import smile.json.ObjectId;

public final class ObjectId$
implements scala.Serializable {
    public static ObjectId$ MODULE$;
    private final int size;
    private final MessageDigest md5Encoder;
    private final int maxCounterValue;
    private final AtomicInteger increment;
    private final byte[] machineId;

    static {
        new ObjectId$();
    }

    public int size() {
        return this.size;
    }

    private MessageDigest md5Encoder() {
        return this.md5Encoder;
    }

    private byte[] md5(byte[] bytes) {
        return this.md5Encoder().digest(bytes);
    }

    private int maxCounterValue() {
        return this.maxCounterValue;
    }

    private AtomicInteger increment() {
        return this.increment;
    }

    private int counter() {
        return (this.increment().getAndIncrement() + this.maxCounterValue()) % this.maxCounterValue();
    }

    public String bytes2hex(byte[] bytes) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$1 -> ObjectId$.$anonfun$bytes2hex$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] hex2bytes(String s) {
        void var2_2;
        Predef$.MODULE$.require(s.length() % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> "Hexadecimal string must contain an even number of characters");
        byte[] bytes = new byte[s.length() / 2];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), s.length()).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            bytes$1[i / 2] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
        });
        return var2_2;
    }

    private byte[] machineId() {
        return this.machineId;
    }

    public ObjectId apply() {
        return this.generate();
    }

    public ObjectId apply(String id) {
        Predef$.MODULE$.require(id.length() == 24, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("wrong ObjectId: '").append(id).append("'").toString());
        return new ObjectId(this.hex2bytes(id));
    }

    public Try<ObjectId> parse(String str) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.apply(str));
    }

    public ObjectId generate() {
        return this.fromTime(System.currentTimeMillis(), false);
    }

    public ObjectId fromTime(long timeMillis, boolean fillOnlyTimestamp) {
        int timestamp = (int)(timeMillis / 1000L);
        byte[] id = new byte[12];
        id[0] = (byte)(timestamp >>> 24);
        id[1] = (byte)(timestamp >> 16 & 0xFF);
        id[2] = (byte)(timestamp >> 8 & 0xFF);
        id[3] = (byte)(timestamp & 0xFF);
        if (!fillOnlyTimestamp) {
            id[4] = this.machineId()[0];
            id[5] = this.machineId()[1];
            id[6] = this.machineId()[2];
            int threadId = (int)Thread.currentThread().getId();
            id[7] = (byte)(threadId & 0xFF);
            id[8] = (byte)(threadId >> 8 & 0xFF);
            int c = this.counter();
            id[9] = (byte)(c >> 16 & 0xFF);
            id[10] = (byte)(c >> 8 & 0xFF);
            id[11] = (byte)(c & 0xFF);
        }
        return new ObjectId(id);
    }

    public boolean fromTime$default$2() {
        return true;
    }

    public ObjectId apply(byte[] id) {
        return new ObjectId(id);
    }

    public Option<byte[]> unapply(ObjectId x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.id());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$bytes2hex$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    public static final /* synthetic */ boolean $anonfun$machineId$4(BoxedUnit x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$machineId$6(NetworkInterface ha) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ha.getHardwareAddress()).isSuccess() && ha.getHardwareAddress() != null && ha.getHardwareAddress().length == 6;
    }

    private ObjectId$() {
        byte[] byArray;
        MODULE$ = this;
        this.size = 12;
        this.md5Encoder = MessageDigest.getInstance("MD5");
        this.maxCounterValue = 0x1000000;
        this.increment = new AtomicInteger(Random$.MODULE$.nextInt(this.maxCounterValue()));
        boolean validPlatform = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean correctVersion = (double)new StringOps(Predef$.MODULE$.augmentString(System.getProperty("java.version").substring(0, 3))).toFloat() >= 1.8;
            String string = System.getProperty("java.net.preferIPv4Stack");
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            boolean noIpv6 = !(string != null ? !string.equals(bl) : bl != null);
            String string2 = System.getProperty("os.name");
            String string3 = "Linux";
            boolean isLinux = !(string2 != null ? !string2.equals(string3) : string3 != null);
            return !isLinux || correctVersion || noIpv6;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        SecurityManager sec = System.getSecurityManager();
        boolean permitted = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sec.checkPermission(new NetPermission("getNetworkInformation"))).toOption().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ObjectId$.$anonfun$machineId$4(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (validPlatform && permitted) {
            Enumeration<NetworkInterface> networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            Iterator networkInterfaces = (Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(networkInterfacesEnum).asScala();
            byte[] ha2 = (byte[])networkInterfaces.find((Function1 & Serializable & scala.Serializable)ha -> BoxesRunTime.boxToBoolean((boolean)ObjectId$.$anonfun$machineId$6(ha))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHardwareAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getHostName().getBytes());
            byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.md5(ha2))).take(3);
        } else {
            int threadId = (int)Thread.currentThread().getId();
            byte[] arr = new byte[]{(byte)(threadId & 0xFF), (byte)(threadId >> 8 & 0xFF), (byte)(threadId >> 16 & 0xFF)};
            byArray = arr;
        }
        this.machineId = byArray;
    }
}

