/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import smile.wavelet.BestLocalizedWavelet;
import smile.wavelet.CoifletWavelet;
import smile.wavelet.D4Wavelet;
import smile.wavelet.DaubechiesWavelet;
import smile.wavelet.HaarWavelet;
import smile.wavelet.SymletWavelet;
import smile.wavelet.Wavelet;
import smile.wavelet.WaveletShrinkage;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"dwt", "", "t", "", "filter", "", "idwt", "wt", "wavelet", "Lsmile/wavelet/Wavelet;", "wsdenoise", "soft", "", "smile-kotlin"})
public final class WaveletKt {
    @NotNull
    public static final Wavelet wavelet(@NotNull String filter) {
        Wavelet wavelet;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        switch (filter) {
            case "haar": {
                wavelet = (Wavelet)new HaarWavelet();
                break;
            }
            case "d4": {
                wavelet = (Wavelet)new D4Wavelet();
                break;
            }
            case "bl14": {
                wavelet = (Wavelet)new BestLocalizedWavelet(14);
                break;
            }
            case "bl18": {
                wavelet = (Wavelet)new BestLocalizedWavelet(18);
                break;
            }
            case "bl20": {
                wavelet = (Wavelet)new BestLocalizedWavelet(20);
                break;
            }
            case "c6": {
                wavelet = (Wavelet)new CoifletWavelet(6);
                break;
            }
            case "c12": {
                wavelet = (Wavelet)new CoifletWavelet(12);
                break;
            }
            case "c18": {
                wavelet = (Wavelet)new CoifletWavelet(18);
                break;
            }
            case "c24": {
                wavelet = (Wavelet)new CoifletWavelet(24);
                break;
            }
            case "c30": {
                wavelet = (Wavelet)new CoifletWavelet(30);
                break;
            }
            case "d6": {
                wavelet = (Wavelet)new DaubechiesWavelet(6);
                break;
            }
            case "d8": {
                wavelet = (Wavelet)new DaubechiesWavelet(8);
                break;
            }
            case "d10": {
                wavelet = (Wavelet)new DaubechiesWavelet(10);
                break;
            }
            case "d12": {
                wavelet = (Wavelet)new DaubechiesWavelet(12);
                break;
            }
            case "d14": {
                wavelet = (Wavelet)new DaubechiesWavelet(14);
                break;
            }
            case "d16": {
                wavelet = (Wavelet)new DaubechiesWavelet(16);
                break;
            }
            case "d18": {
                wavelet = (Wavelet)new DaubechiesWavelet(18);
                break;
            }
            case "d20": {
                wavelet = (Wavelet)new DaubechiesWavelet(20);
                break;
            }
            case "la8": {
                wavelet = (Wavelet)new SymletWavelet(8);
                break;
            }
            case "la10": {
                wavelet = (Wavelet)new SymletWavelet(10);
                break;
            }
            case "la12": {
                wavelet = (Wavelet)new SymletWavelet(12);
                break;
            }
            case "la14": {
                wavelet = (Wavelet)new SymletWavelet(14);
                break;
            }
            case "la16": {
                wavelet = (Wavelet)new SymletWavelet(16);
                break;
            }
            case "la18": {
                wavelet = (Wavelet)new SymletWavelet(18);
                break;
            }
            case "la20": {
                wavelet = (Wavelet)new SymletWavelet(20);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported wavelet: " + filter);
            }
        }
        return wavelet;
    }

    public static final void dwt(@NotNull double[] t, @NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        WaveletKt.wavelet(filter).transform(t);
    }

    public static final void idwt(@NotNull double[] wt, @NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)wt, (String)"wt");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        WaveletKt.wavelet(filter).inverse(wt);
    }

    public static final void wsdenoise(@NotNull double[] t, @NotNull String filter, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        WaveletShrinkage.denoise((double[])t, (Wavelet)WaveletKt.wavelet(filter), (boolean)soft);
    }

    public static /* synthetic */ void wsdenoise$default(double[] dArray, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        WaveletKt.wsdenoise(dArray, string, bl);
    }
}

