/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smile.base.cart.SplitRule;
import smile.base.mlp.LayerBuilder;
import smile.base.rbf.RBF;
import smile.classification.AdaBoost;
import smile.classification.ClassLabels;
import smile.classification.Classifier;
import smile.classification.DecisionTree;
import smile.classification.DiscreteNaiveBayes;
import smile.classification.FLD;
import smile.classification.GradientTreeBoost;
import smile.classification.KNN;
import smile.classification.LDA;
import smile.classification.LogisticRegression;
import smile.classification.MLP;
import smile.classification.Maxent;
import smile.classification.NaiveBayes;
import smile.classification.OneVersusOne;
import smile.classification.OneVersusRest;
import smile.classification.QDA;
import smile.classification.RBFNetwork;
import smile.classification.RDA;
import smile.classification.RandomForest;
import smile.classification.SVM;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.math.distance.Distance;
import smile.math.kernel.MercerKernel;
import smile.neighbor.KNNSearch;
import smile.stat.distribution.Distribution;
import smile.util.IntSet;
import smile.util.function.TimeFunction;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0088\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001aC\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a/\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000e\u001a?\u0010\u000f\u001a\u00020\u00102\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015\u001aG\u0010\u0016\u001a\u00020\u00172\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019\u001ak\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\b\b\u0002\u0010\u001e\u001a\u00020\b2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020\u00122\b\b\u0002\u0010#\u001a\u00020\u00122\b\b\u0002\u0010$\u001a\u00020\u0012\u00a2\u0006\u0002\u0010%\u001aK\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00020'\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020)0\t2\b\b\u0002\u0010*\u001a\u00020+\u00a2\u0006\u0002\u0010,\u001a9\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020+\u00a2\u0006\u0002\u0010-\u001aW\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00020/\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u001e\u001a\u00020\b\u00a2\u0006\u0002\u00103\u001a>\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\b2\b\b\u0002\u0010=\u001a\u00020\b2\b\b\u0002\u0010>\u001a\u00020\b\u001at\u0010?\u001a\u00020@2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010A\u001a\u00020\b2\b\b\u0002\u0010B\u001a\u00020\b2\b\b\u0002\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\b2\b\b\u0002\u0010=\u001a\u00020\b2\b\b\u0002\u0010>\u001a\u00020\b2\b\b\u0002\u0010C\u001a\u00020\u00122\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010E\u001a\u0004\u0018\u00010F\u001aR\u0010G\u001a\u00020H2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010A\u001a\u00020\b2\b\b\u0002\u0010<\u001a\u00020\b2\b\b\u0002\u0010=\u001a\u00020\b2\b\b\u0002\u0010>\u001a\u00020\b2\b\b\u0002\u0010I\u001a\u00020\u00122\b\b\u0002\u0010C\u001a\u00020\u0012\u001a>\u0010J\u001a\u00020K2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010A\u001a\u00020\b2\b\b\u0002\u0010<\u001a\u00020\b2\b\b\u0002\u0010=\u001a\u00020\b2\b\b\u0002\u0010>\u001a\u00020\b\u001a5\u0010L\u001a\u00020M2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010N\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010O\u001a7\u0010P\u001a\u00020Q2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010S\u001a7\u0010T\u001a\u00020U2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010V\u001a?\u0010W\u001a\u00020X2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\u00122\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010Z\u001a?\u0010[\u001a\u00020\\2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010]\u001a\u00020^2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010_\u001a\u00020\u0012\u00a2\u0006\u0002\u0010`\u001a'\u0010[\u001a\u00020a2\u0006\u0010R\u001a\u00020\r2\u0012\u0010b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020c0\t0\t\u00a2\u0006\u0002\u0010d\u001aS\u0010e\u001a\b\u0012\u0004\u0012\u0002H\u00020f\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062$\u0010g\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\t\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020i0h\u00a2\u0006\u0002\u0010j\u001aS\u0010k\u001a\b\u0012\u0004\u0012\u0002H\u00020l\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062$\u0010g\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\t\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020i0h\u00a2\u0006\u0002\u0010m\u00a8\u0006n"}, d2={"knn", "Lsmile/classification/KNN;", "T", "x", "Lsmile/neighbor/KNNSearch;", "y", "", "k", "", "", "distance", "Lsmile/math/distance/Distance;", "([Ljava/lang/Object;[IILsmile/math/distance/Distance;)Lsmile/classification/KNN;", "", "([[D[II)Lsmile/classification/KNN;", "logit", "Lsmile/classification/LogisticRegression;", "lambda", "", "tol", "maxIter", "([[D[IDDI)Lsmile/classification/LogisticRegression;", "maxent", "Lsmile/classification/Maxent;", "p", "([[I[IIDDI)Lsmile/classification/Maxent;", "mlp", "Lsmile/classification/MLP;", "builders", "Lsmile/base/mlp/LayerBuilder;", "epochs", "learningRate", "Lsmile/util/function/TimeFunction;", "momentum", "weightDecay", "rho", "epsilon", "([[D[I[Lsmile/base/mlp/LayerBuilder;ILsmile/util/function/TimeFunction;Lsmile/util/function/TimeFunction;DDD)Lsmile/classification/MLP;", "rbfnet", "Lsmile/classification/RBFNetwork;", "neurons", "Lsmile/base/rbf/RBF;", "normalized", "", "([Ljava/lang/Object;[I[Lsmile/base/rbf/RBF;Z)Lsmile/classification/RBFNetwork;", "([[D[IIZ)Lsmile/classification/RBFNetwork;", "svm", "Lsmile/classification/SVM;", "kernel", "Lsmile/math/kernel/MercerKernel;", "C", "([Ljava/lang/Object;[ILsmile/math/kernel/MercerKernel;DDI)Lsmile/classification/SVM;", "cart", "Lsmile/classification/DecisionTree;", "formula", "Lsmile/data/formula/Formula;", "data", "Lsmile/data/DataFrame;", "splitRule", "Lsmile/base/cart/SplitRule;", "maxDepth", "maxNodes", "nodeSize", "randomForest", "Lsmile/classification/RandomForest;", "ntrees", "mtry", "subsample", "classWeight", "seeds", "", "gbm", "Lsmile/classification/GradientTreeBoost;", "shrinkage", "adaboost", "Lsmile/classification/AdaBoost;", "fisher", "Lsmile/classification/FLD;", "L", "([[D[IID)Lsmile/classification/FLD;", "lda", "Lsmile/classification/LDA;", "priori", "([[D[I[DD)Lsmile/classification/LDA;", "qda", "Lsmile/classification/QDA;", "([[D[I[DD)Lsmile/classification/QDA;", "rda", "Lsmile/classification/RDA;", "alpha", "([[D[ID[DD)Lsmile/classification/RDA;", "naiveBayes", "Lsmile/classification/DiscreteNaiveBayes;", "model", "Lsmile/classification/DiscreteNaiveBayes$Model;", "sigma", "([[I[ILsmile/classification/DiscreteNaiveBayes$Model;[DD)Lsmile/classification/DiscreteNaiveBayes;", "Lsmile/classification/NaiveBayes;", "condprob", "Lsmile/stat/distribution/Distribution;", "([D[[Lsmile/stat/distribution/Distribution;)Lsmile/classification/NaiveBayes;", "ovo", "Lsmile/classification/OneVersusOne;", "trainer", "Lkotlin/Function2;", "Lsmile/classification/Classifier;", "([Ljava/lang/Object;[ILkotlin/jvm/functions/Function2;)Lsmile/classification/OneVersusOne;", "ovr", "Lsmile/classification/OneVersusRest;", "([Ljava/lang/Object;[ILkotlin/jvm/functions/Function2;)Lsmile/classification/OneVersusRest;", "kotlin"})
public final class ClassificationKt {
    @NotNull
    public static final <T> KNN<T> knn(@NotNull KNNSearch<T, T> x, @NotNull int[] y, int k) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return new KNN(x, y, k);
    }

    @NotNull
    public static final <T> KNN<T> knn(@NotNull T[] x, @NotNull int[] y, int k, @NotNull Distance<T> distance) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        KNN kNN = KNN.fit((Object[])x, (int[])y, (int)k, distance);
        Intrinsics.checkNotNullExpressionValue((Object)kNN, (String)"fit(...)");
        return kNN;
    }

    @NotNull
    public static final KNN<double[]> knn(@NotNull double[][] x, @NotNull int[] y, int k) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        KNN kNN = KNN.fit((double[][])x, (int[])y, (int)k);
        Intrinsics.checkNotNullExpressionValue((Object)kNN, (String)"fit(...)");
        return kNN;
    }

    @NotNull
    public static final LogisticRegression logit(@NotNull double[][] x, @NotNull int[] y, double lambda, double tol, int maxIter) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        LogisticRegression logisticRegression = LogisticRegression.fit((double[][])x, (int[])y, (LogisticRegression.Options)new LogisticRegression.Options(lambda, tol, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)logisticRegression, (String)"fit(...)");
        return logisticRegression;
    }

    public static /* synthetic */ LogisticRegression logit$default(double[][] dArray, int[] nArray, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 0.0;
        }
        if ((n2 & 8) != 0) {
            d2 = 1.0E-5;
        }
        if ((n2 & 0x10) != 0) {
            n = 500;
        }
        return ClassificationKt.logit(dArray, nArray, d, d2, n);
    }

    @NotNull
    public static final Maxent maxent(@NotNull int[][] x, @NotNull int[] y, int p, double lambda, double tol, int maxIter) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Maxent maxent = Maxent.fit((int)p, (int[][])x, (int[])y, (Maxent.Options)new Maxent.Options(lambda, tol, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)maxent, (String)"fit(...)");
        return maxent;
    }

    public static /* synthetic */ Maxent maxent$default(int[][] nArray, int[] nArray2, int n, double d, double d2, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            d = 0.1;
        }
        if ((n3 & 0x10) != 0) {
            d2 = 1.0E-5;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 500;
        }
        return ClassificationKt.maxent(nArray, nArray2, n, d, d2, n2);
    }

    @NotNull
    public static final MLP mlp(@NotNull double[][] x, @NotNull int[] y, @NotNull LayerBuilder[] builders, int epochs, @NotNull TimeFunction learningRate, @NotNull TimeFunction momentum, double weightDecay, double rho, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)learningRate, (String)"learningRate");
        Intrinsics.checkNotNullParameter((Object)momentum, (String)"momentum");
        MLP net = new MLP(Arrays.copyOf(builders, builders.length));
        net.setLearningRate(learningRate);
        net.setMomentum(momentum);
        net.setWeightDecay(weightDecay);
        net.setRMSProp(rho, epsilon);
        int i = 1;
        if (i <= epochs) {
            while (true) {
                net.update(x, y);
                if (i == epochs) break;
                ++i;
            }
        }
        return net;
    }

    public static /* synthetic */ MLP mlp$default(double[][] dArray, int[] nArray, LayerBuilder[] layerBuilderArray, int n, TimeFunction timeFunction, TimeFunction timeFunction2, double d, double d2, double d3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        if ((n2 & 0x10) != 0) {
            timeFunction = TimeFunction.linear((double)0.01, (double)10000.0, (double)0.001);
        }
        if ((n2 & 0x20) != 0) {
            timeFunction2 = TimeFunction.constant((double)0.0);
        }
        if ((n2 & 0x40) != 0) {
            d = 0.0;
        }
        if ((n2 & 0x80) != 0) {
            d2 = 0.0;
        }
        if ((n2 & 0x100) != 0) {
            d3 = 1.0E-7;
        }
        return ClassificationKt.mlp(dArray, nArray, layerBuilderArray, n, timeFunction, timeFunction2, d, d2, d3);
    }

    @NotNull
    public static final <T> RBFNetwork<T> rbfnet(@NotNull T[] x, @NotNull int[] y, @NotNull RBF<T>[] neurons, boolean normalized) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter(neurons, (String)"neurons");
        RBFNetwork rBFNetwork = RBFNetwork.fit((Object[])x, (int[])y, neurons, (boolean)normalized);
        Intrinsics.checkNotNullExpressionValue((Object)rBFNetwork, (String)"fit(...)");
        return rBFNetwork;
    }

    public static /* synthetic */ RBFNetwork rbfnet$default(Object[] objectArray, int[] nArray, RBF[] rBFArray, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return ClassificationKt.rbfnet(objectArray, nArray, rBFArray, bl);
    }

    @NotNull
    public static final RBFNetwork<double[]> rbfnet(@NotNull double[][] x, @NotNull int[] y, int k, boolean normalized) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        RBF[] neurons = RBF.fit((double[][])x, (int)k);
        RBFNetwork rBFNetwork = RBFNetwork.fit((Object[])((Object[])x), (int[])y, (RBF[])neurons, (boolean)normalized);
        Intrinsics.checkNotNullExpressionValue((Object)rBFNetwork, (String)"fit(...)");
        return rBFNetwork;
    }

    public static /* synthetic */ RBFNetwork rbfnet$default(double[][] dArray, int[] nArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return ClassificationKt.rbfnet(dArray, nArray, n, bl);
    }

    @NotNull
    public static final <T> SVM<T> svm(@NotNull T[] x, @NotNull int[] y, @NotNull MercerKernel<T> kernel, double C, double tol, int epochs) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter(kernel, (String)"kernel");
        SVM sVM = SVM.fit((Object[])x, (int[])y, kernel, (SVM.Options)new SVM.Options(C, tol, epochs));
        Intrinsics.checkNotNullExpressionValue((Object)sVM, (String)"fit(...)");
        return sVM;
    }

    public static /* synthetic */ SVM svm$default(Object[] objectArray, int[] nArray, MercerKernel mercerKernel, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            d2 = 0.001;
        }
        if ((n2 & 0x20) != 0) {
            n = 1;
        }
        return ClassificationKt.svm(objectArray, nArray, mercerKernel, d, d2, n);
    }

    @NotNull
    public static final DecisionTree cart(@NotNull Formula formula, @NotNull DataFrame data, @NotNull SplitRule splitRule, int maxDepth, int maxNodes, int nodeSize) {
        Intrinsics.checkNotNullParameter((Object)formula, (String)"formula");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)splitRule, (String)"splitRule");
        DecisionTree decisionTree = DecisionTree.fit((Formula)formula, (DataFrame)data, (DecisionTree.Options)new DecisionTree.Options(splitRule, maxDepth, maxNodes, nodeSize));
        Intrinsics.checkNotNullExpressionValue((Object)decisionTree, (String)"fit(...)");
        return decisionTree;
    }

    public static /* synthetic */ DecisionTree cart$default(Formula formula, DataFrame dataFrame, SplitRule splitRule, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            splitRule = SplitRule.GINI;
        }
        if ((n4 & 8) != 0) {
            n = 20;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 5;
        }
        return ClassificationKt.cart(formula, dataFrame, splitRule, n, n2, n3);
    }

    @NotNull
    public static final RandomForest randomForest(@NotNull Formula formula, @NotNull DataFrame data, int ntrees, int mtry, @NotNull SplitRule splitRule, int maxDepth, int maxNodes, int nodeSize, double subsample, @Nullable int[] classWeight, @Nullable long[] seeds) {
        Intrinsics.checkNotNullParameter((Object)formula, (String)"formula");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)splitRule, (String)"splitRule");
        RandomForest randomForest = RandomForest.fit((Formula)formula, (DataFrame)data, (RandomForest.Options)new RandomForest.Options(ntrees, mtry, splitRule, maxDepth, maxNodes, nodeSize, subsample, classWeight, seeds, null));
        Intrinsics.checkNotNullExpressionValue((Object)randomForest, (String)"fit(...)");
        return randomForest;
    }

    public static /* synthetic */ RandomForest randomForest$default(Formula formula, DataFrame dataFrame, int n, int n2, SplitRule splitRule, int n3, int n4, int n5, double d, int[] nArray, long[] lArray, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = 500;
        }
        if ((n6 & 8) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x10) != 0) {
            splitRule = SplitRule.GINI;
        }
        if ((n6 & 0x20) != 0) {
            n3 = 20;
        }
        if ((n6 & 0x40) != 0) {
            n4 = 500;
        }
        if ((n6 & 0x80) != 0) {
            n5 = 1;
        }
        if ((n6 & 0x100) != 0) {
            d = 1.0;
        }
        if ((n6 & 0x200) != 0) {
            nArray = null;
        }
        if ((n6 & 0x400) != 0) {
            lArray = null;
        }
        return ClassificationKt.randomForest(formula, dataFrame, n, n2, splitRule, n3, n4, n5, d, nArray, lArray);
    }

    @NotNull
    public static final GradientTreeBoost gbm(@NotNull Formula formula, @NotNull DataFrame data, int ntrees, int maxDepth, int maxNodes, int nodeSize, double shrinkage, double subsample) {
        Intrinsics.checkNotNullParameter((Object)formula, (String)"formula");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        GradientTreeBoost gradientTreeBoost = GradientTreeBoost.fit((Formula)formula, (DataFrame)data, (GradientTreeBoost.Options)new GradientTreeBoost.Options(ntrees, maxDepth, maxNodes, nodeSize, shrinkage, subsample, null, null));
        Intrinsics.checkNotNullExpressionValue((Object)gradientTreeBoost, (String)"fit(...)");
        return gradientTreeBoost;
    }

    public static /* synthetic */ GradientTreeBoost gbm$default(Formula formula, DataFrame dataFrame, int n, int n2, int n3, int n4, double d, double d2, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 500;
        }
        if ((n5 & 8) != 0) {
            n2 = 20;
        }
        if ((n5 & 0x10) != 0) {
            n3 = 6;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 5;
        }
        if ((n5 & 0x40) != 0) {
            d = 0.05;
        }
        if ((n5 & 0x80) != 0) {
            d2 = 0.7;
        }
        return ClassificationKt.gbm(formula, dataFrame, n, n2, n3, n4, d, d2);
    }

    @NotNull
    public static final AdaBoost adaboost(@NotNull Formula formula, @NotNull DataFrame data, int ntrees, int maxDepth, int maxNodes, int nodeSize) {
        Intrinsics.checkNotNullParameter((Object)formula, (String)"formula");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        AdaBoost adaBoost = AdaBoost.fit((Formula)formula, (DataFrame)data, (AdaBoost.Options)new AdaBoost.Options(ntrees, maxDepth, maxNodes, nodeSize, null, null));
        Intrinsics.checkNotNullExpressionValue((Object)adaBoost, (String)"fit(...)");
        return adaBoost;
    }

    public static /* synthetic */ AdaBoost adaboost$default(Formula formula, DataFrame dataFrame, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 500;
        }
        if ((n5 & 8) != 0) {
            n2 = 20;
        }
        if ((n5 & 0x10) != 0) {
            n3 = 6;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 1;
        }
        return ClassificationKt.adaboost(formula, dataFrame, n, n2, n3, n4);
    }

    @NotNull
    public static final FLD fisher(@NotNull double[][] x, @NotNull int[] y, int L, double tol) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        FLD fLD = FLD.fit((double[][])x, (int[])y, (int)L, (double)tol);
        Intrinsics.checkNotNullExpressionValue((Object)fLD, (String)"fit(...)");
        return fLD;
    }

    public static /* synthetic */ FLD fisher$default(double[][] dArray, int[] nArray, int n, double d, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            d = 1.0E-4;
        }
        return ClassificationKt.fisher(dArray, nArray, n, d);
    }

    @NotNull
    public static final LDA lda(@NotNull double[][] x, @NotNull int[] y, @Nullable double[] priori, double tol) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        LDA lDA = LDA.fit((double[][])x, (int[])y, (double[])priori, (double)tol);
        Intrinsics.checkNotNullExpressionValue((Object)lDA, (String)"fit(...)");
        return lDA;
    }

    public static /* synthetic */ LDA lda$default(double[][] dArray, int[] nArray, double[] dArray2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            dArray2 = null;
        }
        if ((n & 8) != 0) {
            d = 1.0E-4;
        }
        return ClassificationKt.lda(dArray, nArray, dArray2, d);
    }

    @NotNull
    public static final QDA qda(@NotNull double[][] x, @NotNull int[] y, @Nullable double[] priori, double tol) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        QDA qDA = QDA.fit((double[][])x, (int[])y, (double[])priori, (double)tol);
        Intrinsics.checkNotNullExpressionValue((Object)qDA, (String)"fit(...)");
        return qDA;
    }

    public static /* synthetic */ QDA qda$default(double[][] dArray, int[] nArray, double[] dArray2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            dArray2 = null;
        }
        if ((n & 8) != 0) {
            d = 1.0E-4;
        }
        return ClassificationKt.qda(dArray, nArray, dArray2, d);
    }

    @NotNull
    public static final RDA rda(@NotNull double[][] x, @NotNull int[] y, double alpha, @Nullable double[] priori, double tol) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        RDA rDA = RDA.fit((double[][])x, (int[])y, (double)alpha, (double[])priori, (double)tol);
        Intrinsics.checkNotNullExpressionValue((Object)rDA, (String)"fit(...)");
        return rDA;
    }

    public static /* synthetic */ RDA rda$default(double[][] dArray, int[] nArray, double d, double[] dArray2, double d2, int n, Object object) {
        if ((n & 8) != 0) {
            dArray2 = null;
        }
        if ((n & 0x10) != 0) {
            d2 = 1.0E-4;
        }
        return ClassificationKt.rda(dArray, nArray, d, dArray2, d2);
    }

    @NotNull
    public static final DiscreteNaiveBayes naiveBayes(@NotNull int[][] x, @NotNull int[] y, @NotNull DiscreteNaiveBayes.Model model, @Nullable double[] priori, double sigma) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        int p = x[0].length;
        int k = MathEx.max((int[])y) + 1;
        IntSet classes = ClassLabels.fit((int[])y).classes;
        DiscreteNaiveBayes naive = priori == null ? new DiscreteNaiveBayes(model, k, p, sigma, classes) : new DiscreteNaiveBayes(model, priori, p, sigma, classes);
        naive.update(x, y);
        return naive;
    }

    public static /* synthetic */ DiscreteNaiveBayes naiveBayes$default(int[][] nArray, int[] nArray2, DiscreteNaiveBayes.Model model, double[] dArray, double d, int n, Object object) {
        if ((n & 8) != 0) {
            dArray = null;
        }
        if ((n & 0x10) != 0) {
            d = 1.0;
        }
        return ClassificationKt.naiveBayes(nArray, nArray2, model, dArray, d);
    }

    @NotNull
    public static final NaiveBayes naiveBayes(@NotNull double[] priori, @NotNull Distribution[][] condprob) {
        Intrinsics.checkNotNullParameter((Object)priori, (String)"priori");
        Intrinsics.checkNotNullParameter((Object)condprob, (String)"condprob");
        return new NaiveBayes(priori, condprob);
    }

    @NotNull
    public static final <T> OneVersusOne<T> ovo(@NotNull T[] x, @NotNull int[] y, @NotNull Function2<? super T[], ? super int[], ? extends Classifier<T>> trainer) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter(trainer, (String)"trainer");
        OneVersusOne oneVersusOne = OneVersusOne.fit((Object[])x, (int[])y, (arg_0, arg_1) -> ClassificationKt.ovo$lambda$0(trainer, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)oneVersusOne, (String)"fit(...)");
        return oneVersusOne;
    }

    @NotNull
    public static final <T> OneVersusRest<T> ovr(@NotNull T[] x, @NotNull int[] y, @NotNull Function2<? super T[], ? super int[], ? extends Classifier<T>> trainer) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter(trainer, (String)"trainer");
        OneVersusRest oneVersusRest = OneVersusRest.fit((Object[])x, (int[])y, (arg_0, arg_1) -> ClassificationKt.ovr$lambda$1(trainer, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)oneVersusRest, (String)"fit(...)");
        return oneVersusRest;
    }

    private static final Classifier ovo$lambda$0(Function2 $tmp0, Object[] p0, int[] p1) {
        return (Classifier)$tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final Classifier ovr$lambda$1(Function2 $tmp0, Object[] p0, int[] p1) {
        return (Classifier)$tmp0.invoke((Object)p0, (Object)p1);
    }
}

