/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import smile.clustering.CentroidClustering;
import smile.clustering.Clustering;
import smile.clustering.DBSCAN;
import smile.clustering.DENCLUE;
import smile.clustering.DeterministicAnnealing;
import smile.clustering.GMeans;
import smile.clustering.HierarchicalClustering;
import smile.clustering.KMeans;
import smile.clustering.KMedoids;
import smile.clustering.KModes;
import smile.clustering.MEC;
import smile.clustering.SIB;
import smile.clustering.SpectralClustering;
import smile.clustering.XMeans;
import smile.clustering.linkage.CompleteLinkage;
import smile.clustering.linkage.Linkage;
import smile.clustering.linkage.SingleLinkage;
import smile.clustering.linkage.UPGMALinkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMALinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.math.distance.Metric;
import smile.neighbor.RNNSearch;
import smile.util.SparseArray;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a!\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a5\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000b\u001aA\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013\u001aA\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0015\u001a9\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0017\u001a9\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0017\u001aA\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001b\u001aU\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u001f\u001a\u00020\u001e2\b\b\u0002\u0010 \u001a\u00020\u001e\u00a2\u0006\u0002\u0010!\u001aA\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\b0\r\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010#\u001aI\u0010$\u001a\b\u0012\u0004\u0012\u0002H\b0%\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\b0'2\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001e\u00a2\u0006\u0002\u0010*\u001aC\u0010$\u001a\b\u0012\u0004\u0012\u0002H\b0%\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001e\u00a2\u0006\u0002\u0010+\u001a/\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001e\u00a2\u0006\u0002\u0010,\u001a)\u0010-\u001a\u00020.2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0010\u00a2\u0006\u0002\u00101\u001aC\u00102\u001a\b\u0012\u0004\u0012\u0002H\b03\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001e\u00a2\u0006\u0002\u00104\u001aC\u00102\u001a\b\u0012\u0004\u0012\u0002H\b03\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001e\u00a2\u0006\u0002\u00106\u001a/\u00102\u001a\b\u0012\u0004\u0012\u00020\u0004032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001e\u00a2\u0006\u0002\u00107\u001aI\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u001e2\b\b\u0002\u00109\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010:\u00a8\u0006;"}, d2={"hclust", "Lsmile/clustering/HierarchicalClustering;", "data", "", "", "method", "", "([[DLjava/lang/String;)Lsmile/clustering/HierarchicalClustering;", "T", "distance", "Lsmile/math/distance/Distance;", "([Ljava/lang/Object;Lsmile/math/distance/Distance;Ljava/lang/String;)Lsmile/clustering/HierarchicalClustering;", "kmodes", "Lsmile/clustering/CentroidClustering;", "", "k", "", "maxIter", "runs", "([[IIII)Lsmile/clustering/CentroidClustering;", "kmeans", "([[DIII)Lsmile/clustering/CentroidClustering;", "xmeans", "([[DII)Lsmile/clustering/CentroidClustering;", "gmeans", "sib", "Lsmile/util/SparseArray;", "([Lsmile/util/SparseArray;III)Lsmile/clustering/CentroidClustering;", "dac", "alpha", "", "tol", "splitTol", "([[DIDIDD)Lsmile/clustering/CentroidClustering;", "clarans", "([Ljava/lang/Object;Lsmile/math/distance/Distance;I)Lsmile/clustering/CentroidClustering;", "dbscan", "Lsmile/clustering/DBSCAN;", "nns", "Lsmile/neighbor/RNNSearch;", "minPts", "radius", "([Ljava/lang/Object;Lsmile/neighbor/RNNSearch;ID)Lsmile/clustering/DBSCAN;", "([Ljava/lang/Object;Lsmile/math/distance/Distance;ID)Lsmile/clustering/DBSCAN;", "([[DID)Lsmile/clustering/DBSCAN;", "denclue", "Lsmile/clustering/DENCLUE;", "sigma", "m", "([[DDI)Lsmile/clustering/DENCLUE;", "mec", "Lsmile/clustering/MEC;", "([Ljava/lang/Object;Lsmile/math/distance/Distance;ID)Lsmile/clustering/MEC;", "Lsmile/math/distance/Metric;", "([Ljava/lang/Object;Lsmile/math/distance/Metric;ID)Lsmile/clustering/MEC;", "([[DID)Lsmile/clustering/MEC;", "specc", "l", "([[DIDII)Lsmile/clustering/CentroidClustering;", "kotlin"})
public final class ClusteringKt {
    @NotNull
    public static final HierarchicalClustering hclust(@NotNull double[][] data, @NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Linkage linkage = switch (method) {
            case "single" -> (Linkage)SingleLinkage.of((double[][])data);
            case "complete" -> (Linkage)CompleteLinkage.of((double[][])data);
            case "average", "upgma" -> (Linkage)UPGMALinkage.of((double[][])data);
            case "centroid", "upgmc" -> (Linkage)UPGMCLinkage.of((double[][])data);
            case "wpgma" -> (Linkage)WPGMALinkage.of((double[][])data);
            case "median", "wpgmc" -> (Linkage)WPGMCLinkage.of((double[][])data);
            case "ward" -> (Linkage)WardLinkage.of((double[][])data);
            default -> throw new IllegalArgumentException("Unknown agglomeration method: " + method);
        };
        HierarchicalClustering hierarchicalClustering = HierarchicalClustering.fit((Linkage)linkage);
        Intrinsics.checkNotNullExpressionValue((Object)hierarchicalClustering, (String)"fit(...)");
        return hierarchicalClustering;
    }

    @NotNull
    public static final <T> HierarchicalClustering hclust(@NotNull T[] data, @NotNull Distance<T> distance, @NotNull String method) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Linkage linkage = switch (method) {
            case "single" -> (Linkage)SingleLinkage.of((Object[])data, distance);
            case "complete" -> (Linkage)CompleteLinkage.of((Object[])data, distance);
            case "average", "upgma" -> (Linkage)UPGMALinkage.of((Object[])data, distance);
            case "centroid", "upgmc" -> (Linkage)UPGMCLinkage.of((Object[])data, distance);
            case "wpgma" -> (Linkage)WPGMALinkage.of((Object[])data, distance);
            case "median", "wpgmc" -> (Linkage)WPGMCLinkage.of((Object[])data, distance);
            case "ward" -> (Linkage)WardLinkage.of((Object[])data, distance);
            default -> throw new IllegalArgumentException("Unknown agglomeration method: " + method);
        };
        HierarchicalClustering hierarchicalClustering = HierarchicalClustering.fit((Linkage)linkage);
        Intrinsics.checkNotNullExpressionValue((Object)hierarchicalClustering, (String)"fit(...)");
        return hierarchicalClustering;
    }

    @NotNull
    public static final CentroidClustering<int[], int[]> kmodes(@NotNull int[][] data, int k, int maxIter, int runs) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Comparable comparable = Clustering.run((int)runs, () -> ClusteringKt.kmodes$lambda$0(data, k, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"run(...)");
        return (CentroidClustering)comparable;
    }

    public static /* synthetic */ CentroidClustering kmodes$default(int[][] nArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 100;
        }
        if ((n4 & 8) != 0) {
            n3 = 10;
        }
        return ClusteringKt.kmodes(nArray, n, n2, n3);
    }

    @NotNull
    public static final CentroidClustering<double[], double[]> kmeans(@NotNull double[][] data, int k, int maxIter, int runs) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Comparable comparable = Clustering.run((int)runs, () -> ClusteringKt.kmeans$lambda$1(data, k, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"run(...)");
        return (CentroidClustering)comparable;
    }

    public static /* synthetic */ CentroidClustering kmeans$default(double[][] dArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 100;
        }
        if ((n4 & 8) != 0) {
            n3 = 16;
        }
        return ClusteringKt.kmeans(dArray, n, n2, n3);
    }

    @NotNull
    public static final CentroidClustering<double[], double[]> xmeans(@NotNull double[][] data, int k, int maxIter) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CentroidClustering centroidClustering = XMeans.fit((double[][])data, (int)k, (int)maxIter);
        Intrinsics.checkNotNullExpressionValue((Object)centroidClustering, (String)"fit(...)");
        return centroidClustering;
    }

    public static /* synthetic */ CentroidClustering xmeans$default(double[][] dArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 100;
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        return ClusteringKt.xmeans(dArray, n, n2);
    }

    @NotNull
    public static final CentroidClustering<double[], double[]> gmeans(@NotNull double[][] data, int k, int maxIter) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CentroidClustering centroidClustering = GMeans.fit((double[][])data, (int)k, (int)maxIter);
        Intrinsics.checkNotNullExpressionValue((Object)centroidClustering, (String)"fit(...)");
        return centroidClustering;
    }

    public static /* synthetic */ CentroidClustering gmeans$default(double[][] dArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 100;
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        return ClusteringKt.gmeans(dArray, n, n2);
    }

    @NotNull
    public static final CentroidClustering<double[], SparseArray> sib(@NotNull SparseArray[] data, int k, int maxIter, int runs) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Comparable comparable = Clustering.run((int)runs, () -> ClusteringKt.sib$lambda$2(data, k, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"run(...)");
        return (CentroidClustering)comparable;
    }

    public static /* synthetic */ CentroidClustering sib$default(SparseArray[] sparseArrayArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 100;
        }
        if ((n4 & 8) != 0) {
            n3 = 8;
        }
        return ClusteringKt.sib(sparseArrayArray, n, n2, n3);
    }

    @NotNull
    public static final CentroidClustering<double[], double[]> dac(@NotNull double[][] data, int k, double alpha, int maxIter, double tol, double splitTol) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CentroidClustering centroidClustering = DeterministicAnnealing.fit((double[][])data, (DeterministicAnnealing.Options)new DeterministicAnnealing.Options(k, alpha, maxIter, tol, splitTol, null));
        Intrinsics.checkNotNullExpressionValue((Object)centroidClustering, (String)"fit(...)");
        return centroidClustering;
    }

    public static /* synthetic */ CentroidClustering dac$default(double[][] dArray, int n, double d, int n2, double d2, double d3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 0.9;
        }
        if ((n3 & 8) != 0) {
            n2 = 100;
        }
        if ((n3 & 0x10) != 0) {
            d2 = 1.0E-4;
        }
        if ((n3 & 0x20) != 0) {
            d3 = 0.01;
        }
        return ClusteringKt.dac(dArray, n, d, n2, d2, d3);
    }

    @NotNull
    public static final <T> CentroidClustering<T, T> clarans(@NotNull T[] data, @NotNull Distance<T> distance, int k) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        CentroidClustering centroidClustering = KMedoids.fit((Object[])data, distance, (int)k);
        Intrinsics.checkNotNullExpressionValue((Object)centroidClustering, (String)"fit(...)");
        return centroidClustering;
    }

    @NotNull
    public static final <T> DBSCAN<T> dbscan(@NotNull T[] data, @NotNull RNNSearch<T, T> nns, int minPts, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(nns, (String)"nns");
        DBSCAN dBSCAN = DBSCAN.fit((Object[])data, nns, (int)minPts, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)dBSCAN, (String)"fit(...)");
        return dBSCAN;
    }

    @NotNull
    public static final <T> DBSCAN<T> dbscan(@NotNull T[] data, @NotNull Distance<T> distance, int minPts, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        DBSCAN dBSCAN = DBSCAN.fit((Object[])data, distance, (int)minPts, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)dBSCAN, (String)"fit(...)");
        return dBSCAN;
    }

    @NotNull
    public static final DBSCAN<double[]> dbscan(@NotNull double[][] data, int minPts, double radius) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return ClusteringKt.dbscan((Object[])data, (Distance)new EuclideanDistance(), minPts, radius);
    }

    @NotNull
    public static final DENCLUE denclue(@NotNull double[][] data, double sigma, int m) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DENCLUE dENCLUE = DENCLUE.fit((double[][])data, (double)sigma, (int)m);
        Intrinsics.checkNotNullExpressionValue((Object)dENCLUE, (String)"fit(...)");
        return dENCLUE;
    }

    @NotNull
    public static final <T> MEC<T> mec(@NotNull T[] data, @NotNull Distance<T> distance, int k, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        MEC mEC = MEC.fit((Object[])data, distance, (int)k, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(...)");
        return mEC;
    }

    @NotNull
    public static final <T> MEC<T> mec(@NotNull T[] data, @NotNull Metric<T> distance, int k, double radius) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        MEC mEC = MEC.fit((Object[])data, (Distance)((Distance)distance), (int)k, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(...)");
        return mEC;
    }

    @NotNull
    public static final MEC<double[]> mec(@NotNull double[][] data, int k, double radius) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MEC mEC = MEC.fit((Object[])((Object[])data), (Distance)((Distance)new EuclideanDistance()), (int)k, (double)radius);
        Intrinsics.checkNotNullExpressionValue((Object)mEC, (String)"fit(...)");
        return mEC;
    }

    @NotNull
    public static final CentroidClustering<double[], double[]> specc(@NotNull double[][] data, int k, double sigma, int l, int maxIter) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CentroidClustering centroidClustering = SpectralClustering.fit((double[][])data, (SpectralClustering.Options)new SpectralClustering.Options(k, l, sigma, maxIter));
        Intrinsics.checkNotNullExpressionValue((Object)centroidClustering, (String)"fit(...)");
        return centroidClustering;
    }

    public static /* synthetic */ CentroidClustering specc$default(double[][] dArray, int n, double d, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 100;
        }
        return ClusteringKt.specc(dArray, n, d, n2, n3);
    }

    private static final CentroidClustering kmodes$lambda$0(int[][] $data, int $k, int $maxIter) {
        return KModes.fit((int[][])$data, (int)$k, (int)$maxIter);
    }

    private static final CentroidClustering kmeans$lambda$1(double[][] $data, int $k, int $maxIter) {
        return KMeans.fit((double[][])$data, (int)$k, (int)$maxIter);
    }

    private static final CentroidClustering sib$lambda$2(SparseArray[] $data, int $k, int $maxIter) {
        return SIB.fit((SparseArray[])$data, (int)$k, (int)$maxIter);
    }
}

