/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import smile.wavelet.BestLocalizedWavelet;
import smile.wavelet.CoifletWavelet;
import smile.wavelet.D4Wavelet;
import smile.wavelet.DaubechiesWavelet;
import smile.wavelet.HaarWavelet;
import smile.wavelet.SymletWavelet;
import smile.wavelet.Wavelet;
import smile.wavelet.WaveletShrinkage;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"wavelet", "Lsmile/wavelet/Wavelet;", "filter", "", "dwt", "", "t", "", "idwt", "wt", "wsdenoise", "soft", "", "kotlin"})
public final class WaveletKt {
    @NotNull
    public static final Wavelet wavelet(@NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return switch (filter) {
            case "haar" -> (Wavelet)new HaarWavelet();
            case "d4" -> (Wavelet)new D4Wavelet();
            case "bl14" -> (Wavelet)new BestLocalizedWavelet(14);
            case "bl18" -> (Wavelet)new BestLocalizedWavelet(18);
            case "bl20" -> (Wavelet)new BestLocalizedWavelet(20);
            case "c6" -> (Wavelet)new CoifletWavelet(6);
            case "c12" -> (Wavelet)new CoifletWavelet(12);
            case "c18" -> (Wavelet)new CoifletWavelet(18);
            case "c24" -> (Wavelet)new CoifletWavelet(24);
            case "c30" -> (Wavelet)new CoifletWavelet(30);
            case "d6" -> (Wavelet)new DaubechiesWavelet(6);
            case "d8" -> (Wavelet)new DaubechiesWavelet(8);
            case "d10" -> (Wavelet)new DaubechiesWavelet(10);
            case "d12" -> (Wavelet)new DaubechiesWavelet(12);
            case "d14" -> (Wavelet)new DaubechiesWavelet(14);
            case "d16" -> (Wavelet)new DaubechiesWavelet(16);
            case "d18" -> (Wavelet)new DaubechiesWavelet(18);
            case "d20" -> (Wavelet)new DaubechiesWavelet(20);
            case "la8" -> (Wavelet)new SymletWavelet(8);
            case "la10" -> (Wavelet)new SymletWavelet(10);
            case "la12" -> (Wavelet)new SymletWavelet(12);
            case "la14" -> (Wavelet)new SymletWavelet(14);
            case "la16" -> (Wavelet)new SymletWavelet(16);
            case "la18" -> (Wavelet)new SymletWavelet(18);
            case "la20" -> (Wavelet)new SymletWavelet(20);
            default -> throw new IllegalArgumentException("Unsupported wavelet: " + filter);
        };
    }

    public static final void dwt(@NotNull double[] t, @NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        WaveletKt.wavelet(filter).transform(t);
    }

    public static final void idwt(@NotNull double[] wt, @NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)wt, (String)"wt");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        WaveletKt.wavelet(filter).inverse(wt);
    }

    public static final void wsdenoise(@NotNull double[] t, @NotNull String filter, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        WaveletShrinkage.denoise((double[])t, (Wavelet)WaveletKt.wavelet(filter), (boolean)soft);
    }

    public static /* synthetic */ void wsdenoise$default(double[] dArray, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        WaveletKt.wsdenoise(dArray, string, bl);
    }
}

