/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.util.HashSet;
import java.util.Set;
import smile.math.distance.Distance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccardDistance<T>
implements Distance<T[]> {
    public String toString() {
        return "Jaccard distance";
    }

    @Override
    public double d(T[] a, T[] b) {
        int i;
        HashSet<T> union = new HashSet<T>();
        HashSet<T> intersection = new HashSet<T>();
        for (i = 0; i < b.length; ++i) {
            union.add(b[i]);
        }
        for (i = 0; i < a.length; ++i) {
            intersection.add(a[i]);
        }
        intersection.retainAll(union);
        for (i = 0; i < a.length; ++i) {
            union.add(a[i]);
        }
        return 1.0 - (double)intersection.size() / (double)union.size();
    }

    public static <T> double d(Set<T> a, Set<T> b) {
        HashSet<T> union = new HashSet<T>(a);
        union.addAll(b);
        HashSet<T> intersection = new HashSet<T>(a);
        intersection.retainAll(b);
        return 1.0 - (double)intersection.size() / (double)union.size();
    }
}

